"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesTables = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _loader = require("../../../../common/components/loader");
var _use_bool_state = require("../../../../common/hooks/use_bool_state");
var _load_empty_prompt = require("../pre_packaged_rules/load_empty_prompt");
var i18n = _interopRequireWildcard(require("../../../common/translations"));
var _bulk_action_dry_run_confirmation = require("./bulk_actions/bulk_action_dry_run_confirmation");
var _bulk_edit_flyout = require("./bulk_actions/bulk_edit_flyout");
var _use_bulk_actions = require("./bulk_actions/use_bulk_actions");
var _use_bulk_actions_confirmation = require("./bulk_actions/use_bulk_actions_confirmation");
var _use_bulk_actions_dry_run = require("./bulk_actions/use_bulk_actions_dry_run");
var _use_bulk_edit_form_flyout = require("./bulk_actions/use_bulk_edit_form_flyout");
var _rules_table_context = require("./rules_table/rules_table_context");
var _use_async_confirmation = require("./rules_table/use_async_confirmation");
var _rules_table_filters = require("./rules_table_filters/rules_table_filters");
var _rules_table_toolbar = require("./rules_table_toolbar");
var _rules_table_utility_bar = require("../rules_table_utility_bar/rules_table_utility_bar");
var _use_columns = require("./use_columns");
var _user_info = require("../../../../detections/components/user_info");
var _privileges = require("../../../../common/utils/privileges");
var _use_bulk_duplicate_confirmation = require("./bulk_actions/use_bulk_duplicate_confirmation");
var _bulk_duplicate_exceptions_confirmation = require("./bulk_actions/bulk_duplicate_exceptions_confirmation");
var _use_start_ml_jobs = require("../../../rule_management/logic/use_start_ml_jobs");
var _constants = require("./constants");
var _use_rule_management_filters = require("../../../rule_management/logic/use_rule_management_filters");
var _use_upgrade_security_packages = require("../../../rule_management/logic/use_upgrade_security_packages");
var _use_manual_rule_run_confirmation = require("../../../rule_gaps/components/manual_rule_run/use_manual_rule_run_confirmation");
var _manual_rule_run = require("../../../rule_gaps/components/manual_rule_run");
var _bulk_manual_rule_run_limit_error_modal = require("./bulk_actions/bulk_manual_rule_run_limit_error_modal");
var _rules_with_gaps_overview_panel = require("../../../rule_gaps/components/rules_with_gaps_overview_panel");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _bulk_edit_delete_alert_suprression_confirmation = require("./bulk_actions/bulk_edit_delete_alert_suprression_confirmation");
var _rule_management = require("../../../../../common/api/detection_engine/rule_management");
var _bulk_fill_rule_gaps = require("../../../rule_gaps/components/bulk_fill_rule_gaps");
var _use_bulk_fill_rule_gaps_confirmation = require("../../../rule_gaps/components/bulk_fill_rule_gaps/use_bulk_fill_rule_gaps_confirmation");
var _bulk_schedule_gap_fills_rule_limit_error_modal = require("./bulk_actions/bulk_schedule_gap_fills_rule_limit_error_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/rules_tables.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INITIAL_SORT_FIELD = 'enabled';
const NO_ITEMS_MESSAGE = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  title: /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 26
    }
  }, i18n.NO_RULES),
  titleSize: "xs",
  body: i18n.NO_RULES_BODY,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 3
  }
});

/**
 * Table Component for displaying all Rules for a given cluster. Provides the ability to filter
 * by name, sort by enabled, and perform the following actions:
 *   * Enable/Disable
 *   * Duplicate
 *   * Delete
 *   * Import/Export
 */
// eslint-disable-next-line complexity
const RulesTables = exports.RulesTables = /*#__PURE__*/_react.default.memo(({
  selectedTab
}) => {
  var _selectedRuleIds$leng, _bulkActionsDryRunRes, _bulkActionsDryRunRes2;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [{
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const hasPermissions = (0, _privileges.hasUserCRUDPermission)(canUserCRUD);
  const isUpgradingSecurityPackages = (0, _use_upgrade_security_packages.useIsUpgradingSecurityPackages)();
  const rulesTableContext = (0, _rules_table_context.useRulesTableContext)();
  const {
    data: ruleManagementFilters
  } = (0, _use_rule_management_filters.useRuleManagementFilters)();
  const {
    state: {
      rules,
      filterOptions,
      isPreflightInProgress,
      isAllSelected,
      isFetched,
      isLoading,
      isRefetching,
      loadingRuleIds,
      loadingRulesAction,
      pagination,
      selectedRuleIds,
      sortingOptions
    },
    actions: {
      setIsAllSelected,
      setPage,
      setPerPage,
      setSelectedRuleIds,
      setSortingOptions
    }
  } = rulesTableContext;
  const [isDeleteConfirmationVisible, showDeleteConfirmation, hideDeleteConfirmation] = (0, _use_bool_state.useBoolState)();
  const [confirmDeletion, handleDeletionConfirm, handleDeletionCancel] = (0, _use_async_confirmation.useAsyncConfirmation)({
    onInit: showDeleteConfirmation,
    onFinish: hideDeleteConfirmation
  });

  // If no rules are selected, we are deleting a single rule
  const rulesToDeleteCount = isAllSelected ? pagination.total : selectedRuleIds.length || 1;
  const {
    bulkActionsDryRunResult,
    bulkAction,
    isBulkActionConfirmationVisible,
    showBulkActionConfirmation,
    cancelBulkActionConfirmation,
    approveBulkActionConfirmation
  } = (0, _use_bulk_actions_confirmation.useBulkActionsConfirmation)();
  const {
    isBulkDuplicateConfirmationVisible,
    showBulkDuplicateConfirmation,
    cancelRuleDuplication,
    confirmRuleDuplication
  } = (0, _use_bulk_duplicate_confirmation.useBulkDuplicateExceptionsConfirmation)();
  const {
    isManualRuleRunConfirmationVisible,
    showManualRuleRunConfirmation,
    cancelManualRuleRun,
    confirmManualRuleRun
  } = (0, _use_manual_rule_run_confirmation.useManualRuleRunConfirmation)();
  const {
    isBulkFillRuleGapsConfirmationVisible,
    showBulkFillRuleGapsConfirmation,
    cancelBulkFillRuleGaps,
    confirmBulkFillRuleGaps
  } = (0, _use_bulk_fill_rule_gaps_confirmation.useBulkFillRuleGapsConfirmation)();
  const [isManualRuleRunLimitErrorVisible, showManualRuleRunLimitError, hideManualRuleRunLimitError] = (0, _use_bool_state.useBoolState)();
  const [isBulkFillRuleGapsRuleLimitErrorVisible, showBulkFillRuleGapsRuleLimitError, hideBulkFillRuleGapsRuleLimitError] = (0, _use_bool_state.useBoolState)();
  const {
    bulkEditActionType,
    isBulkEditFlyoutVisible,
    handleBulkEditFormConfirm,
    handleBulkEditFormCancel,
    completeBulkEditForm
  } = (0, _use_bulk_edit_form_flyout.useBulkEditFormFlyout)();
  const {
    isBulkActionsDryRunLoading,
    executeBulkActionsDryRun
  } = (0, _use_bulk_actions_dry_run.useBulkActionsDryRun)();
  const getBulkItemsPopoverContent = (0, _use_bulk_actions.useBulkActions)({
    filterOptions,
    confirmDeletion,
    showBulkActionConfirmation,
    showBulkDuplicateConfirmation,
    showManualRuleRunConfirmation,
    showBulkFillRuleGapsConfirmation,
    showManualRuleRunLimitError,
    showBulkFillRuleGapsRuleLimitError,
    completeBulkEditForm,
    executeBulkActionsDryRun
  });
  const paginationMemo = (0, _react.useMemo)(() => {
    return {
      pageIndex: pagination.page - 1,
      pageSize: pagination.perPage,
      totalItemCount: pagination.total,
      pageSizeOptions: _constants.RULES_TABLE_PAGE_SIZE_OPTIONS
    };
  }, [pagination.page, pagination.perPage, pagination.total]);
  const tableOnChangeCallback = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    var _ref, _sort$direction;
    setSortingOptions({
      field: (_ref = sort === null || sort === void 0 ? void 0 : sort.field) !== null && _ref !== void 0 ? _ref : INITIAL_SORT_FIELD,
      // Narrowing EuiBasicTable sorting types
      order: (_sort$direction = sort === null || sort === void 0 ? void 0 : sort.direction) !== null && _sort$direction !== void 0 ? _sort$direction : 'desc'
    });
    setPage(page.index + 1);
    setPerPage(page.size);
  }, [setPage, setPerPage, setSortingOptions]);
  const {
    loading: isLoadingJobs,
    jobs: mlJobs,
    startMlJobs
  } = (0, _use_start_ml_jobs.useStartMlJobs)();
  const rulesColumns = (0, _use_columns.useRulesColumns)({
    hasCRUDPermissions: hasPermissions,
    isLoadingJobs,
    mlJobs,
    startMlJobs,
    showExceptionsDuplicateConfirmation: showBulkDuplicateConfirmation,
    showManualRuleRunConfirmation,
    confirmDeletion
  });
  const monitoringColumns = (0, _use_columns.useMonitoringColumns)({
    hasCRUDPermissions: hasPermissions,
    isLoadingJobs,
    mlJobs,
    startMlJobs,
    showExceptionsDuplicateConfirmation: showBulkDuplicateConfirmation,
    showManualRuleRunConfirmation,
    confirmDeletion
  });
  const isSelectAllCalled = (0, _react.useRef)(false);
  const isTableSelectable = hasPermissions && (selectedTab === _rules_table_toolbar.AllRulesTabs.management || selectedTab === _rules_table_toolbar.AllRulesTabs.monitoring);
  const euiBasicTableSelectionProps = (0, _react.useMemo)(() => ({
    selectable: item => !loadingRuleIds.includes(item.id),
    onSelectionChange: selected => {
      setSelectedRuleIds(selected.map(({
        id
      }) => id));
      setIsAllSelected(false);
    },
    selected: selectedRuleIds.map(id => ({
      id
    })) // EuiBasicTable only needs the itemId
  }), [loadingRuleIds, setIsAllSelected, setSelectedRuleIds, selectedRuleIds]);
  const toggleSelectAll = (0, _react.useCallback)(() => {
    isSelectAllCalled.current = true;
    setIsAllSelected(!isAllSelected);
    setSelectedRuleIds(!isAllSelected ? rules.map(({
      id
    }) => id) : []);
  }, [rules, isAllSelected, setIsAllSelected, setSelectedRuleIds]);
  const storeGapsInEventLogEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('storeGapsInEventLogEnabled');
  const isTableEmpty = (ruleManagementFilters === null || ruleManagementFilters === void 0 ? void 0 : ruleManagementFilters.rules_summary.custom_count) === 0 && (ruleManagementFilters === null || ruleManagementFilters === void 0 ? void 0 : ruleManagementFilters.rules_summary.prebuilt_installed_count) === 0;
  const shouldShowRulesTable = !isLoading && !isTableEmpty;
  let tableProps;
  switch (selectedTab) {
    case _rules_table_toolbar.AllRulesTabs.management:
      tableProps = {
        'data-test-subj': 'rules-management-table',
        columns: rulesColumns
      };
      break;
    case _rules_table_toolbar.AllRulesTabs.monitoring:
      tableProps = {
        'data-test-subj': 'rules-monitoring-table',
        columns: monitoringColumns
      };
      break;
    default:
      tableProps = {
        'data-test-subj': 'rules-management-table',
        columns: rulesColumns
      };
      break;
  }
  const shouldShowLinearProgress = isFetched && isRefetching || isUpgradingSecurityPackages;
  const shouldShowLoadingOverlay = !isFetched && isRefetching || isPreflightInProgress;
  const rulesCount = Math.max(isAllSelected ? pagination.total : (_selectedRuleIds$leng = selectedRuleIds === null || selectedRuleIds === void 0 ? void 0 : selectedRuleIds.length) !== null && _selectedRuleIds$leng !== void 0 ? _selectedRuleIds$leng : 0, 1);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, shouldShowLinearProgress && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": "loadingRulesInfoProgress",
    size: "xs",
    position: "absolute",
    color: "accent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 9
    }
  }), shouldShowLoadingOverlay && /*#__PURE__*/_react.default.createElement(_loader.Loader, {
    "data-test-subj": "loadingPanelAllRulesTable",
    overlay: true,
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 9
    }
  }), isTableEmpty && /*#__PURE__*/_react.default.createElement(_load_empty_prompt.PrePackagedRulesPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 24
    }
  }), isDeleteConfirmationVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    title: rulesToDeleteCount === 1 ? i18n.SINGLE_DELETE_CONFIRMATION_TITLE : i18n.BULK_DELETE_CONFIRMATION_TITLE,
    onCancel: handleDeletionCancel,
    onConfirm: () => handleDeletionConfirm(),
    confirmButtonText: i18n.DELETE_CONFIRMATION_CONFIRM,
    cancelButtonText: i18n.DELETE_CONFIRMATION_CANCEL,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    "data-test-subj": "deleteRulesConfirmationModal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.components.allRules.deleteConfirmationModalBody",
    defaultMessage: "This action will delete {rulesToDeleteCount, plural, one {the chosen rule} other {{rulesToDeleteCountStrong} rules}}. Click \"Delete\" to continue.",
    values: {
      rulesToDeleteCount,
      rulesToDeleteCountStrong: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 315,
          columnNumber: 41
        }
      }, rulesToDeleteCount)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 11
    }
  })), isManualRuleRunConfirmationVisible && /*#__PURE__*/_react.default.createElement(_manual_rule_run.ManualRuleRunModal, {
    onCancel: cancelManualRuleRun,
    onConfirm: confirmManualRuleRun,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 9
    }
  }), isBulkFillRuleGapsConfirmationVisible && /*#__PURE__*/_react.default.createElement(_bulk_fill_rule_gaps.BulkFillRuleGapsModal, {
    onCancel: cancelBulkFillRuleGaps,
    onConfirm: confirmBulkFillRuleGaps,
    rulesCount: selectedRuleIds.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 9
    }
  }), isManualRuleRunLimitErrorVisible && /*#__PURE__*/_react.default.createElement(_bulk_manual_rule_run_limit_error_modal.BulkManualRuleRunLimitErrorModal, {
    onClose: hideManualRuleRunLimitError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 9
    }
  }), isBulkFillRuleGapsRuleLimitErrorVisible && /*#__PURE__*/_react.default.createElement(_bulk_schedule_gap_fills_rule_limit_error_modal.BulkFillRuleGapsRuleLimitErrorModal, {
    onClose: hideBulkFillRuleGapsRuleLimitError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 9
    }
  }), isBulkActionConfirmationVisible && bulkAction && /*#__PURE__*/_react.default.createElement(_bulk_action_dry_run_confirmation.BulkActionDryRunConfirmation, {
    bulkAction: bulkAction,
    result: bulkActionsDryRunResult,
    onCancel: cancelBulkActionConfirmation,
    onConfirm: approveBulkActionConfirmation,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 9
    }
  }), isBulkDuplicateConfirmationVisible && /*#__PURE__*/_react.default.createElement(_bulk_duplicate_exceptions_confirmation.BulkActionDuplicateExceptionsConfirmation, {
    onCancel: cancelRuleDuplication,
    onConfirm: confirmRuleDuplication,
    rulesCount: rulesCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 9
    }
  }), isBulkEditFlyoutVisible && bulkEditActionType && (bulkEditActionType === _rule_management.BulkActionEditTypeEnum.delete_alert_suppression ? /*#__PURE__*/_react.default.createElement(_bulk_edit_delete_alert_suprression_confirmation.BulkEditDeleteAlertSuppressionConfirmation, {
    rulesCount: (_bulkActionsDryRunRes = bulkActionsDryRunResult === null || bulkActionsDryRunResult === void 0 ? void 0 : bulkActionsDryRunResult.succeededRulesCount) !== null && _bulkActionsDryRunRes !== void 0 ? _bulkActionsDryRunRes : 0,
    onCancel: handleBulkEditFormCancel,
    onConfirm: handleBulkEditFormConfirm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_bulk_edit_flyout.BulkEditFlyout, {
    rulesCount: (_bulkActionsDryRunRes2 = bulkActionsDryRunResult === null || bulkActionsDryRunResult === void 0 ? void 0 : bulkActionsDryRunResult.succeededRulesCount) !== null && _bulkActionsDryRunRes2 !== void 0 ? _bulkActionsDryRunRes2 : 0,
    editAction: bulkEditActionType,
    onClose: handleBulkEditFormCancel,
    onConfirm: handleBulkEditFormConfirm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 11
    }
  })), shouldShowRulesTable && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedTab === _rules_table_toolbar.AllRulesTabs.monitoring && storeGapsInEventLogEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_rules_with_gaps_overview_panel.RulesWithGapsOverviewPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_rules_table_filters.RulesTableFilters, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_rules_table_utility_bar.RulesTableUtilityBar, {
    canBulkEdit: hasPermissions,
    onGetBulkItemsPopoverContent: getBulkItemsPopoverContent,
    onToggleSelectAll: toggleSelectAll,
    isBulkActionInProgress: isBulkActionsDryRunLoading || loadingRulesAction != null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 377,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, (0, _extends2.default)({
    itemId: "id",
    items: rules,
    noItemsMessage: NO_ITEMS_MESSAGE,
    onChange: tableOnChangeCallback,
    pagination: paginationMemo,
    selection: isTableSelectable ? euiBasicTableSelectionProps : undefined,
    sorting: {
      sort: {
        // EuiBasicTable has incorrect `sort.field` types which accept only `keyof Item` and reject fields in dot notation
        field: sortingOptions.field,
        direction: sortingOptions.order
      }
    }
  }, tableProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 383,
      columnNumber: 11
    }
  }))));
});
RulesTables.displayName = 'RulesTables';