"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkSetSchedule = exports.bulkDuplicateRuleActions = exports.bulkApplyTimelineTemplate = exports.bulkAlertSuppression = exports.bulkAddRuleActions = exports.ML_RULES_UNAVAILABLE = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/bulk_actions/translations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const bulkApplyTimelineTemplate = exports.bulkApplyTimelineTemplate = {
  FORM_TITLE: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.applyTimelineTemplate.formTitle', {
    defaultMessage: 'Apply Timeline template'
  }),
  TEMPLATE_SELECTOR_LABEL: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.applyTimelineTemplate.templateSelectorLabel', {
    defaultMessage: 'Apply Timeline template to selected rules'
  }),
  TEMPLATE_SELECTOR_HELP_TEXT: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.applyTimelineTemplate.templateSelectorHelpText', {
    defaultMessage: 'Select which Timeline to apply to selected rules when investigating generated alerts.'
  }),
  TEMPLATE_SELECTOR_PLACEHOLDER: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.applyTimelineTemplate.templateSelectorPlaceholder', {
    defaultMessage: 'Search Timeline template'
  }),
  TEMPLATE_SELECTOR_DEFAULT_VALUE: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.applyTimelineTemplate.templateSelectorDefaultValue', {
    defaultMessage: 'None'
  }),
  warningCalloutMessage: rulesCount => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.applyTimelineTemplate.warningCalloutMessage",
    defaultMessage: "You're about to apply changes to {rulesCount, plural, one {# selected rule} other {# selected rules}}. If you previously applied Timeline templates to these rules, they will be overwritten or (if you select 'None') reset to none.",
    values: {
      rulesCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  })
};
const bulkAddRuleActions = exports.bulkAddRuleActions = {
  FORM_TITLE: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.addRuleActions.formTitle', {
    defaultMessage: 'Add rule actions'
  }),
  OVERWRITE_LABEL: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.addRuleActions.overwriteCheckboxLabel', {
    defaultMessage: 'Overwrite all selected rules actions'
  }),
  RULE_VARIABLES_DETAIL: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.addRuleActions.ruleVariablesDetail', {
    defaultMessage: 'Rule variables may affect only some of the rules you select, based on the rule types (for example, \\u007b\\u007bcontext.rule.threshold\\u007d\\u007d will only display values for threshold rules).'
  })
};
const bulkSetSchedule = exports.bulkSetSchedule = {
  FORM_TITLE: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.setSchedule.formTitle', {
    defaultMessage: 'Update rule schedules'
  }),
  INTERVAL_LABEL: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.setSchedule.intervalLabel', {
    defaultMessage: 'Runs every'
  }),
  INTERVAL_HELP_TEXT: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.setSchedule.intervalHelpText', {
    defaultMessage: 'Rules run periodically and detect alerts within the specified time frame.'
  }),
  LOOKBACK_LABEL: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.setSchedule.lookbackLabel', {
    defaultMessage: 'Additional look-back time'
  }),
  LOOKBACK_HELP_TEXT: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.setSchedule.lookbackHelpText', {
    defaultMessage: 'Adds time to the look-back period to prevent missed alerts.'
  }),
  warningCalloutMessage: rulesCount => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.setSchedule.warningCalloutMessage",
    defaultMessage: "You're about to apply changes to {rulesCount, plural, one {# selected rule} other {# selected rules}}. The changes you make will overwrite the existing rule schedules and additional look-back time (if any).",
    values: {
      rulesCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  })
};
const bulkDuplicateRuleActions = exports.bulkDuplicateRuleActions = {
  MODAL_TITLE: rulesCount => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.duplicate.exception.confirmation.modalTitle",
    defaultMessage: "Duplicate {rulesCount, plural, one {the rule} other {rules}}?",
    values: {
      rulesCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  }),
  MODAL_TEXT: rulesCount => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.duplicate.exceptionsConfirmation.modalBody",
    defaultMessage: "You're duplicating {rulesCount, plural, one {# rule} other {# rules}}. Choose what to duplicate:",
    values: {
      rulesCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 5
    }
  }),
  DUPLICATE_EXCEPTIONS_TEXT: rulesCount => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.duplicate.exceptionsConfirmation.with",
    defaultMessage: "The {rulesCount, plural, one {rule} other {rules}} and {rulesCount, plural, one {its} other {their}} active exceptions",
    values: {
      rulesCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 5
    }
  }),
  DUPLICATE_EXCEPTIONS_INCLUDE_EXPIRED_EXCEPTIONS_LABEL: rulesCount => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.duplicate.includeExpiredExceptionsCheckboxLabel",
    defaultMessage: "The {rulesCount, plural, one {rule} other {rules}} and {rulesCount, plural, one {its} other {their}} exceptions",
    values: {
      rulesCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 5
    }
  }),
  DUPLICATE_WITHOUT_EXCEPTIONS_TEXT: rulesCount => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.duplicate.exceptionsConfirmation.without",
    defaultMessage: "Only the {rulesCount, plural, one {rule} other {rules}}",
    values: {
      rulesCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 5
    }
  }),
  CONTINUE_BUTTON: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.duplicate.exceptionsConfirmation.continueButton', {
    defaultMessage: 'Duplicate'
  }),
  CANCEL_BUTTON: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.duplicate.exceptionsConfirmation.cancelButton', {
    defaultMessage: 'Cancel'
  }),
  DUPLICATE_TOOLTIP: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.duplicate.exceptionsConfirmation.tooltip', {
    defaultMessage: 'Exception items associated with individual rules are duplicated. Exception items linked to shared exception lists are not. Instead, duplicated rules will reference the shared exception lists that contain the exception items.'
  })
};
const ML_RULES_UNAVAILABLE = totalRules => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.mlUnavailableTitle', {
  values: {
    totalRules
  },
  defaultMessage: '{totalRules} {totalRules, plural, =1 {rule requires} other {rules require}} Machine Learning to enable.'
});
exports.ML_RULES_UNAVAILABLE = ML_RULES_UNAVAILABLE;
const bulkAlertSuppression = exports.bulkAlertSuppression = {
  SUPPRESSION_MAX_LENGTH_ERROR: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.alertSuppression.alertSuppressionMaxLengthErrorMessage', {
    defaultMessage: 'Number of suppress by fields must be at most 3.'
  }),
  SET_TITLE: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.alertSuppression.addTitle', {
    defaultMessage: 'Apply alert suppression'
  }),
  SET_FOR_THRESHOLD_TITLE: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.alertSuppression.addTitle', {
    defaultMessage: 'Apply alert suppression to threshold rules'
  }),
  SUPPRESSION_REQUIRED_ERROR: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.edit.alertSuppressionRequiredErrorMessage', {
    defaultMessage: 'A minimum of one suppression field is required.'
  }),
  SUPPRESSION_INFO_TEXT: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.alertSuppression.infoText', {
    defaultMessage: 'Existing alert suppression settings will be overwritten for all of the selected rules, except for threshold rules.'
  }),
  SUPPRESSION_FOR_THRESHOLD_INFO_TEXT: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.alertSuppressionForThreshold.infoText', {
    defaultMessage: 'Existing alert suppression settings will be overwritten for all of the selected threshold rules.'
  }),
  DELETE_CONFIRMATION_TITLE: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.alertSuppression.bulkDeleteConfirmationTitle', {
    defaultMessage: 'Confirm bulk removal of alert suppression'
  }),
  DELETE_CONFIRMATION_CONFIRM: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.alertSuppression.deleteConfirmationConfirm', {
    defaultMessage: 'Delete'
  }),
  DELETE_CONFIRMATION_CANCEL: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.alertSuppression.deleteConfirmationCancel', {
    defaultMessage: 'Cancel'
  }),
  DURATION_PER_TIME_PERIOD_INPUT: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.alertSuppression.perTimePeriodInput', {
    defaultMessage: 'Per time period'
  }),
  DURATION_PER_TIME_PERIOD_LABEL: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.alertSuppression.perTimePeriodLabel', {
    defaultMessage: 'Suppression interval'
  }),
  DURATION_PER_TIME_PERIOD_HELP_TEXT: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.alertSuppression.perTimePeriodHelpText', {
    defaultMessage: 'Suppress alerts for the selected rules within a repeating time interval. To ensure suppression is appropriately applied, avoid choosing an interval that’s shorter than the rule’s run schedule.'
  })
};