"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThresholdInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _translations = require("./translations");
var _styles = _interopRequireWildcard(require("./styles"));
var styles = _styles;
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/threshold_input/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fieldDescribedByIds = ['detectionEngineStepDefineRuleThresholdField'];
const valueDescribedByIds = ['detectionEngineStepDefineRuleThresholdValue'];
const cardinalityFieldDescribedByIds = ['detectionEngineStepDefineRuleThresholdCardinalityField'];
const cardinalityValueDescribedByIds = ['detectionEngineStepDefineRuleThresholdCardinalityValue'];
const ThresholdInputComponent = ({
  thresholdField,
  thresholdValue,
  browserFields,
  thresholdCardinalityField,
  thresholdCardinalityValue
}) => {
  const fieldEuiFieldProps = (0, _react.useMemo)(() => ({
    fullWidth: true,
    noSuggestions: false,
    options: browserFields.map(field => ({
      label: field.name
    })),
    placeholder: _translations.THRESHOLD_FIELD_PLACEHOLDER,
    onCreateOption: undefined
  }), [browserFields]);
  const cardinalityFieldEuiProps = (0, _react.useMemo)(() => ({
    fullWidth: true,
    noSuggestions: false,
    options: browserFields.map(field => ({
      label: field.name
    })),
    placeholder: _translations.THRESHOLD_FIELD_PLACEHOLDER,
    onCreateOption: undefined,
    singleSelection: {
      asPlainText: true
    }
  }), [browserFields]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    className: styles.mainContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.FieldSectionGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: styles.dropdownContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Field, {
    field: thresholdField,
    idAria: fieldDescribedByIds[0],
    "data-test-subj": fieldDescribedByIds[0],
    describedByIds: fieldDescribedByIds,
    type: thresholdField.type,
    euiFieldProps: fieldEuiFieldProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: styles.operatorContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, '>='), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: styles.input,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Field, {
    field: thresholdValue,
    idAria: valueDescribedByIds[0],
    "data-test-subj": valueDescribedByIds[0],
    describedByIds: valueDescribedByIds,
    type: thresholdValue.type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_styles.FieldSectionGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: styles.dropdownContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Field, {
    field: thresholdCardinalityField,
    idAria: cardinalityFieldDescribedByIds[0],
    "data-test-subj": cardinalityFieldDescribedByIds[0],
    describedByIds: cardinalityFieldDescribedByIds,
    type: thresholdCardinalityField.type,
    euiFieldProps: cardinalityFieldEuiProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: styles.operatorContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, '>='), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: styles.input,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Field, {
    field: thresholdCardinalityValue,
    idAria: cardinalityValueDescribedByIds[0],
    "data-test-subj": cardinalityValueDescribedByIds[0],
    describedByIds: cardinalityValueDescribedByIds,
    type: thresholdCardinalityValue.type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }))));
};
const ThresholdInput = exports.ThresholdInput = /*#__PURE__*/_react.default.memo(ThresholdInputComponent);