"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MitreAttackSubtechniqueFields = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var Rulei18n = _interopRequireWildcard(require("../../../common/translations"));
var _add_item_form = require("../add_item_form");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/mitre/subtechnique_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const lazyMitreConfiguration = () => {
  /**
   * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
   * See https://webpack.js.org/api/module-methods/#magic-comments
   */
  return Promise.resolve().then(() => _interopRequireWildcard(require(/* webpackChunkName: "lazy_mitre_configuration" */
  '../../../../detections/mitre/mitre_tactics_techniques')));
};
const SubtechniqueContainer = _styledComponents.default.div`
  margin-left: 48px;
`;
const MitreAttackSubtechniqueFields = ({
  field,
  idAria,
  isDisabled,
  threatIndex,
  techniqueIndex,
  onFieldChange
}) => {
  const values = field.value;
  const [subtechniquesOptions, setSubtechniquesOptions] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    async function getMitre() {
      const mitreConfig = await lazyMitreConfiguration();
      setSubtechniquesOptions(mitreConfig.subtechniques);
    }
    getMitre();
  }, []);
  const technique = (0, _react.useMemo)(() => {
    var _values$threatIndex$t;
    return [...((_values$threatIndex$t = values[threatIndex].technique) !== null && _values$threatIndex$t !== void 0 ? _values$threatIndex$t : [])];
  }, [values, threatIndex]);
  const removeSubtechnique = (0, _react.useCallback)(index => {
    var _technique$techniqueI;
    const threats = [...field.value];
    const subtechniques = (_technique$techniqueI = technique[techniqueIndex].subtechnique) !== null && _technique$techniqueI !== void 0 ? _technique$techniqueI : [];
    if (subtechniques != null) {
      subtechniques.splice(index, 1);
      technique[techniqueIndex] = {
        ...technique[techniqueIndex],
        subtechnique: subtechniques
      };
      threats[threatIndex].technique = technique;
      onFieldChange(threats);
    }
  }, [field, onFieldChange, techniqueIndex, technique, threatIndex]);
  const addMitreAttackSubtechnique = (0, _react.useCallback)(() => {
    const threats = [...field.value];
    const subtechniques = technique[techniqueIndex].subtechnique;
    if (subtechniques != null) {
      technique[techniqueIndex] = {
        ...technique[techniqueIndex],
        subtechnique: [...subtechniques, {
          id: 'none',
          name: 'none',
          reference: 'none'
        }]
      };
    } else {
      technique[techniqueIndex] = {
        ...technique[techniqueIndex],
        subtechnique: [{
          id: 'none',
          name: 'none',
          reference: 'none'
        }]
      };
    }
    threats[threatIndex].technique = technique;
    onFieldChange(threats);
  }, [field, onFieldChange, techniqueIndex, technique, threatIndex]);
  const updateSubtechnique = (0, _react.useCallback)((index, optionId) => {
    var _subtechniquesOptions;
    const threats = [...field.value];
    const {
      id,
      reference,
      name
    } = (_subtechniquesOptions = subtechniquesOptions.find(t => t.id === optionId)) !== null && _subtechniquesOptions !== void 0 ? _subtechniquesOptions : {
      id: '',
      name: '',
      reference: ''
    };
    const subtechniques = technique[techniqueIndex].subtechnique;
    if (subtechniques != null) {
      onFieldChange([...threats.slice(0, threatIndex), {
        ...threats[threatIndex],
        technique: [...technique.slice(0, techniqueIndex), {
          ...technique[techniqueIndex],
          subtechnique: [...subtechniques.slice(0, index), {
            id,
            reference,
            name
          }, ...subtechniques.slice(index + 1)]
        }, ...technique.slice(techniqueIndex + 1)]
      }, ...threats.slice(threatIndex + 1)]);
    }
  }, [field.value, subtechniquesOptions, technique, techniqueIndex, onFieldChange, threatIndex]);
  const getSelectSubtechnique = (0, _react.useCallback)((index, disabled, subtechnique) => {
    const options = subtechniquesOptions.filter(t => t.techniqueId === technique[techniqueIndex].id);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      id: "mitreAttackSubtechnique",
      options: [...(subtechnique.name === 'none' ? [{
        inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.SUBTECHNIQUE_PLACEHOLDER),
        value: 'none',
        disabled
      }] : []), ...options.map(option => ({
        inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, option.label),
        value: option.id,
        disabled
      }))],
      prepend: `${field.label} ${i18n.SUBTECHNIQUE}`,
      "aria-label": "",
      onChange: updateSubtechnique.bind(null, index),
      fullWidth: true,
      valueOfSelected: subtechnique.id,
      "data-test-subj": "mitreAttackSubtechnique",
      disabled: disabled,
      placeholder: i18n.SUBTECHNIQUE_PLACEHOLDER,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 11
      }
    }));
  }, [subtechniquesOptions, field.label, updateSubtechnique, technique, techniqueIndex]);
  const subtechniques = (0, _react.useMemo)(() => {
    return technique[techniqueIndex].subtechnique;
  }, [technique, techniqueIndex]);
  return /*#__PURE__*/_react.default.createElement(SubtechniqueContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 5
    }
  }, subtechniques != null && subtechniques.map((subtechnique, index) => /*#__PURE__*/_react.default.createElement("div", {
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    describedByIds: idAria ? [`${idAria} ${i18n.SUBTECHNIQUE}`] : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 17
    }
  }, getSelectSubtechnique(index, isDisabled, subtechnique)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    iconType: "trash",
    isDisabled: isDisabled,
    onClick: () => removeSubtechnique(index),
    "aria-label": Rulei18n.DELETE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 19
    }
  })))))), /*#__PURE__*/_react.default.createElement(_add_item_form.MyAddItemButton, {
    "data-test-subj": "addMitreAttackSubtechnique",
    onClick: addMitreAttackSubtechnique,
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 7
    }
  }, i18n.ADD_MITRE_SUBTECHNIQUE));
};
exports.MitreAttackSubtechniqueFields = MitreAttackSubtechniqueFields;