"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSuppressionLabel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _utils = require("../../../../../common/detection_engine/utils");
var _technical_preview_badge = require("../../../../common/components/technical_preview_badge");
var _use_upselling = require("../../../../common/hooks/use_upselling");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/description_step/alert_suppression_label.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AlertSuppressionLabel = ({
  label,
  ruleType
}) => {
  const alertSuppressionUpsellingMessage = (0, _use_upselling.useUpsellingMessage)('alert_suppression_rule_details');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ruleType && (0, _utils.isSuppressionRuleInGA)(ruleType) ? label : /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
    label: label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 9
    }
  }), alertSuppressionUpsellingMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: alertSuppressionUpsellingMessage,
    position: "top",
    type: "warning",
    size: "l",
    color: "danger",
    css: {
      marginLeft: '8px'
    },
    iconProps: {
      'data-test-subj': 'alertSuppressionInsufficientLicensingIcon'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 9
    }
  }));
};
exports.AlertSuppressionLabel = AlertSuppressionLabel;