"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DurationInput = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var I18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/duration_input/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// This component is similar to the ScheduleItem component, but instead of combining the value
// and unit into a single string it keeps them separate. This makes the component simpler and
// allows for easier validation of values and units in APIs as well.
const DurationInput = exports.DurationInput = /*#__PURE__*/(0, _react.memo)(function DurationInputComponent({
  durationValueField,
  durationUnitField,
  minimumValue = 0,
  isDisabled,
  durationUnitOptions = [{
    value: 's',
    text: I18n.SECONDS
  }, {
    value: 'm',
    text: I18n.MINUTES
  }, {
    value: 'h',
    text: I18n.HOURS
  }],
  'aria-label': ariaLabel,
  ...props
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    isInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(durationValueField);
  const {
    value: durationValue,
    setValue: setDurationValue
  } = durationValueField;
  const {
    value: durationUnit,
    setValue: setDurationUnit
  } = durationUnitField;
  const onChangeTimeType = (0, _react.useCallback)(e => {
    setDurationUnit(e.target.value);
  }, [setDurationUnit]);
  const onChangeTimeVal = (0, _react.useCallback)(e => {
    const sanitizedValue = getNumberFromUserInput(e.target.value, minimumValue);
    setDurationValue(sanitizedValue);
  }, [minimumValue, setDurationValue]);
  const durationFormRowStyle = (0, _react2.css)`
    max-width: 235px;

    .euiFormControlLayout__append {
      padding-inline: 0 !important;
    }

    .euiFormControlLayoutIcons {
      color: ${euiTheme.colors.primary};
    }
  `;
  const durationUnitSelectStyle = (0, _react2.css)`
    min-width: 106px; // Preserve layout when disabled & dropdown arrow is not rendered
    box-shadow: none !important; // Override disabled state
    background: ${euiTheme.colors.backgroundBasePrimary} !important;
    color: ${euiTheme.colors.primary};

    &:disabled {
      border-left: ${euiTheme.border.thin};
      border-top-left-radius: 0;
      border-bottom-left-radius: 0;
    }
  `;
  const durationInputStyle = (0, _react2.css)`
    box-shadow: none !important; // Override disabled state
  `;

  // EUI missing some props
  const rest = {
    disabled: isDisabled,
    ...props
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    css: durationFormRowStyle,
    error: errorMessage,
    isInvalid: isInvalid,
    isDisabled: isDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({
    isInvalid: isInvalid,
    css: durationInputStyle,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
      css: durationUnitSelectStyle,
      options: durationUnitOptions,
      onChange: onChangeTimeType,
      value: durationUnit,
      "aria-label": I18n.DURATION_UNIT_SELECTOR,
      "data-test-subj": "timeType"
    }, rest, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 11
      }
    })),
    min: minimumValue,
    max: Number.MAX_SAFE_INTEGER,
    onChange: onChangeTimeVal,
    value: durationValue,
    "data-test-subj": "interval",
    "aria-label": ariaLabel
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  })));
});
function getNumberFromUserInput(input, minimumValue = 0) {
  const number = parseInt(input, 10);
  if (Number.isNaN(number)) {
    return minimumValue;
  } else {
    return Math.max(minimumValue, Math.min(number, Number.MAX_SAFE_INTEGER));
  }
}