"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleStatusFailedCallOut = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _formatted_date = require("../../../../common/components/formatted_date");
var _rule_monitoring = require("../../../../../common/api/detection_engine/rule_monitoring");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_assistant_availability = require("../../../../assistant/use_assistant_availability");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/common/components/rule_execution_status/rule_status_failed_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuleStatusFailedCallOutComponent = ({
  ruleName,
  ruleNameForChat,
  dataSources,
  date,
  message,
  status
}) => {
  const {
    hasAssistantPrivilege,
    isAssistantEnabled
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const {
    shouldBeDisplayed,
    color,
    title
  } = getPropsByStatus(status);
  const getPromptContext = (0, _react.useCallback)(async () => ruleName != null && dataSources != null ? `Rule name: ${ruleName}\nData sources: ${dataSources}\nError message: ${message}` : `Error message: ${message}`, [message, ruleName, dataSources]);
  const chatTitle = (0, _react.useMemo)(() => {
    return `${ruleNameForChat} - ${title} ${date}`;
  }, [date, title, ruleNameForChat]);
  if (!shouldBeDisplayed) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        pre {
          margin-block-end: 0;
          margin-right: 24px; // Otherwise the copy button overlaps the scrollbar
          padding-inline-end: 0;
        }
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, title, " ", /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      value: date,
      fieldName: "execution_summary.last_execution.date",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 21
      }
    })),
    color: color,
    iconType: "warning",
    "data-test-subj": "ruleStatusFailedCallOut",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    className: "eui-fullWidth",
    paddingSize: "none",
    isCopyable: true,
    overflowHeight: 96,
    transparentBackground: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, message), hasAssistantPrivilege && /*#__PURE__*/_react.default.createElement(_elasticAssistant.NewChat, {
    category: "detection-rules",
    color: color,
    conversationTitle: chatTitle,
    description: i18n.ASK_ASSISTANT_DESCRIPTION,
    getPromptContext: getPromptContext,
    suggestedUserPrompt: i18n.ASK_ASSISTANT_USER_PROMPT,
    tooltip: i18n.ASK_ASSISTANT_TOOLTIP,
    isAssistantEnabled: isAssistantEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, i18n.ASK_ASSISTANT_ERROR_BUTTON)));
};
const RuleStatusFailedCallOut = exports.RuleStatusFailedCallOut = /*#__PURE__*/_react.default.memo(RuleStatusFailedCallOutComponent);
RuleStatusFailedCallOut.displayName = 'RuleStatusFailedCallOut';
const getPropsByStatus = status => {
  switch (status) {
    case _rule_monitoring.RuleExecutionStatusEnum.failed:
      return {
        shouldBeDisplayed: true,
        color: 'danger',
        title: i18n.ERROR_CALLOUT_TITLE
      };
    case _rule_monitoring.RuleExecutionStatusEnum['partial failure']:
      return {
        shouldBeDisplayed: true,
        color: 'warning',
        title: i18n.PARTIAL_FAILURE_CALLOUT_TITLE
      };
    default:
      return {
        shouldBeDisplayed: false,
        color: 'warning',
        title: ''
      };
  }
};