"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withSpaceId = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_space_id = require("../../hooks/use_space_id");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/with_space_id/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 *
 * This HOC ensures that component get valid non-null
 * spaceId if the component needs it is as an invariant
 *
 * */
const withSpaceId = (Component, fallback) => {
  const ComponentWithSpaceId = props => {
    const spaceId = (0, _use_space_id.useSpaceId)();
    if (!spaceId) {
      return fallback !== null && fallback !== void 0 ? fallback : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "text",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        "data-test-subj": "filter-group__loading",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 13
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
      spaceId: spaceId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 12
      }
    }));
  };
  return ComponentWithSpaceId;
};
exports.withSpaceId = withSpaceId;