"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationActions = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/ui-actions-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _constants = require("../../store/inputs/constants");
var _modal = require("../inspect/modal");
var _use_inspect = require("../inspect/use_inspect");
var _use_lens_attributes = require("./use_lens_attributes");
var _translations = require("./translations");
var _utils = require("./utils");
var _use_actions = require("./use_actions");
var _model = require("../../../sourcerer/store/model");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/visualization_actions/actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Wrapper = _styled.default.div`
  &.viz-actions {
    position: absolute;
    top: 0;
    right: 0;
    z-index: 1;
  }
  &.histogram-viz-actions {
    padding: ${({
  theme
}) => theme.euiTheme.size.s};
  }
`;
const VisualizationActionsComponent = ({
  applyGlobalQueriesAndFilters = true,
  className,
  extraActions,
  extraOptions,
  getLensAttributes,
  inputId = _constants.InputsModelId.global,
  inspectIndex = 0,
  isInspectButtonDisabled,
  isMultipleQuery,
  lensAttributes,
  onCloseInspect,
  queryId,
  timerange,
  title: inspectTitle,
  scopeId = _model.SourcererScopeName.default,
  stackByField,
  withActions = _use_actions.DEFAULT_ACTIONS,
  casesAttachmentMetadata
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const [isInspectModalOpen, setIsInspectModalOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => {
    setPopover(!isPopoverOpen);
  }, [isPopoverOpen]);
  const closePopover = () => {
    setPopover(false);
  };
  const attributes = (0, _use_lens_attributes.useLensAttributes)({
    applyGlobalQueriesAndFilters,
    extraOptions,
    getLensAttributes,
    lensAttributes,
    scopeId,
    stackByField,
    title: ''
  });
  const dataTestSubj = `stat-${queryId}`;
  const onOpenInspectModal = (0, _react.useCallback)(() => {
    closePopover();
    setIsInspectModalOpen(true);
  }, []);
  const onCloseInspectModal = (0, _react.useCallback)(() => {
    setIsInspectModalOpen(false);
    if (onCloseInspect) {
      onCloseInspect();
    }
  }, [onCloseInspect]);
  const {
    additionalRequests,
    additionalResponses,
    handleClick: handleInspectButtonClick,
    handleCloseModal: handleCloseInspectModal,
    isButtonDisabled: disableInspectButton,
    request,
    response
  } = (0, _use_inspect.useInspect)({
    inputId,
    inspectIndex,
    isDisabled: isInspectButtonDisabled,
    multiple: isMultipleQuery,
    onCloseInspect: onCloseInspectModal,
    onClick: onOpenInspectModal,
    queryId
  });
  const inspectActionProps = (0, _react.useMemo)(() => ({
    handleInspectClick: handleInspectButtonClick,
    isInspectButtonDisabled: disableInspectButton
  }), [disableInspectButton, handleInspectButtonClick]);
  const contextMenuActions = (0, _use_actions.useActions)({
    attributes,
    extraActions,
    inspectActionProps,
    timeRange: timerange,
    withActions,
    lensMetadata: casesAttachmentMetadata
  });
  const panels = (0, _useAsync.default)(() => (0, _public.buildContextMenuForActions)({
    actions: contextMenuActions.map(action => ({
      action,
      context: {},
      trigger: _use_actions.VISUALIZATION_CONTEXT_MENU_TRIGGER
    }))
  }), [contextMenuActions]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _translations.MORE_ACTIONS,
    className: _utils.VISUALIZATION_ACTIONS_BUTTON_CLASS,
    "data-test-subj": dataTestSubj,
    iconType: "boxesHorizontal",
    onClick: onButtonClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }), [dataTestSubj, onButtonClick]);
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    className: className,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 5
    }
  }, panels.value && panels.value.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    panelClassName: "withHoverActions__popover",
    "data-test-subj": "viz-actions-popover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    "data-test-subj": "viz-actions-panel",
    size: "s",
    panels: panels.value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  })), isInspectModalOpen && request !== null && response !== null && /*#__PURE__*/_react.default.createElement(_modal.ModalInspectQuery, {
    additionalRequests: additionalRequests,
    additionalResponses: additionalResponses,
    closeModal: handleCloseInspectModal,
    inputId: inputId,
    request: request,
    response: response,
    title: inspectTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  }));
};
VisualizationActionsComponent.displayName = 'VisualizationActionsComponent';
const VisualizationActions = exports.VisualizationActions = /*#__PURE__*/_react.default.memo(VisualizationActionsComponent);