"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorerLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/ml-plugin/public");
var _kibana = require("../../../lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/ml/links/create_explorer_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ExplorerLink = ({
  score,
  startDate,
  endDate,
  linkName
}) => {
  const {
    services: {
      ml,
      http
    }
  } = (0, _kibana.useKibana)();
  const explorerUrl = (0, _public.useMlHref)(ml, http.basePath.get(), {
    page: 'explorer',
    pageState: {
      jobIds: [score.jobId],
      timeRange: {
        from: new Date(startDate).toISOString(),
        to: new Date(endDate).toISOString(),
        mode: 'absolute'
      },
      refreshInterval: {
        pause: true,
        value: 0
      }
    }
  }, [score.jobId]);
  if (!explorerUrl) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: explorerUrl,
    target: "_blank",
    "data-test-subj": `explorer-link-${score.jobId}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, linkName);
};
exports.ExplorerLink = ExplorerLink;