"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserNameFromInfluencers = void 0;
var _get_entries = require("../get_entries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUserNameFromInfluencers = (influencers = [], userName) => {
  const recordFound = influencers.find(influencer => {
    const [influencerName, influencerValue] = (0, _get_entries.getEntries)(influencer);
    if (influencerName === 'user.name') {
      if (userName == null) {
        return true;
      } else {
        return influencerValue === userName;
      }
    } else {
      return false;
    }
  });
  if (recordFound != null) {
    return Object.values(recordFound)[0];
  } else {
    return null;
  }
};
exports.getUserNameFromInfluencers = getUserNameFromInfluencers;