"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderer = exports.plugin = exports.parser = exports.insightPrefix = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _esQuery = require("@kbn/es-query");
var _reactHookForm = require("react-hook-form");
var _use_data_view = require("../../../../../data_view_manager/hooks/use_data_view");
var _use_experimental_features = require("../../../../hooks/use_experimental_features");
var _use_upselling = require("../../../../hooks/use_upselling");
var _use_app_toasts = require("../../../../hooks/use_app_toasts");
var _kibana = require("../../../../lib/kibana");
var _use_insight_query = require("./use_insight_query");
var _use_insight_data_providers = require("./use_insight_data_providers");
var _investigation_guide_view = require("../../../../../flyout/document_details/left/components/investigation_guide_view");
var _investigate_in_timeline_button = require("../../../event_details/investigate_in_timeline_button");
var _default_date_settings = require("../../../../utils/default_date_settings");
var _constants = require("../../../../../../common/constants");
var _containers = require("../../../../../sourcerer/containers");
var _model = require("../../../../../sourcerer/store/model");
var _provider = require("./provider");
var _use_license = require("../../../../hooks/use_license");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_get_sourcerer_data_view = require("../../../../../sourcerer/components/use_get_sourcerer_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/markdown_editor/plugins/insight/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const insightPrefix = exports.insightPrefix = '!{investigate';
const parser = function () {
  const Parser = this.Parser;
  const tokenizers = Parser.prototype.inlineTokenizers;
  const methods = Parser.prototype.inlineMethods;
  const tokenizeInsight = function (eat, value, silent) {
    if (value.startsWith(insightPrefix) === false) {
      return false;
    }
    const nextChar = value[insightPrefix.length];
    if (nextChar !== '{' && nextChar !== '}') return false;
    if (silent) {
      return true;
    }

    // is there a configuration?
    const hasConfiguration = nextChar === '{';
    let configuration = {};
    if (hasConfiguration) {
      let configurationString = '';
      let openObjects = 0;
      for (let i = insightPrefix.length; i < value.length; i++) {
        const char = value[i];
        if (char === '{') {
          openObjects++;
          configurationString += char;
        } else if (char === '}') {
          openObjects--;
          if (openObjects === -1) {
            break;
          }
          configurationString += char;
        } else {
          configurationString += char;
        }
      }
      try {
        configuration = JSON.parse(configurationString);
        return eat(value)({
          type: 'insight',
          ...configuration,
          providers: JSON.stringify(configuration.providers)
        });
      } catch (err) {
        const now = eat.now();
        this.file.fail(i18n.INVALID_FILTER_ERROR(err), {
          line: now.line,
          column: now.column + insightPrefix.length
        });
      }
    }
    return false;
  };
  tokenizeInsight.locator = (value, fromIndex) => {
    return value.indexOf(insightPrefix, fromIndex);
  };
  tokenizers.insight = tokenizeInsight;
  methods.splice(methods.indexOf('text'), 0, 'insight');
};
exports.parser = parser;
const resultFormat = '0,0.[000]a';
const LicensedInsightComponent = ({
  label,
  description,
  providers,
  relativeFrom,
  relativeTo
}) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  let parsedProviders = [];
  try {
    if (providers !== undefined) {
      parsedProviders = JSON.parse(providers);
    }
  } catch (err) {
    addError(err, {
      title: i18n.PARSE_ERROR
    });
  }
  const {
    data: alertData,
    timestamp
  } = (0, _react.useContext)(_investigation_guide_view.BasicAlertDataContext);
  const {
    dataProviders,
    filters
  } = (0, _use_insight_data_providers.useInsightDataProviders)({
    providers: parsedProviders,
    alertData
  });
  const relativeTimerange = (0, _react.useMemo)(() => {
    if (relativeFrom && relativeTo) {
      const alertRelativeDate = timestamp ? (0, _moment.default)(timestamp) : (0, _moment.default)();
      const from = (0, _default_date_settings.parseDateWithDefault)(relativeFrom, _default_date_settings.DEFAULT_FROM_MOMENT, false, _moment.default, alertRelativeDate.toDate()).toISOString();
      const to = (0, _default_date_settings.parseDateWithDefault)(relativeTo, _default_date_settings.DEFAULT_TO_MOMENT, true, _moment.default, alertRelativeDate.toDate()).toISOString();
      return {
        kind: 'absolute',
        from,
        to
      };
    } else {
      return null;
    }
  }, [relativeFrom, relativeTo, timestamp]);
  const {
    totalCount,
    isQueryLoading,
    oldestTimestamp,
    hasError
  } = (0, _use_insight_query.useInsightQuery)({
    dataProviders,
    filters,
    relativeTimerange
  });
  const timerange = (0, _react.useMemo)(() => {
    if (relativeTimerange) {
      return relativeTimerange;
    } else if (oldestTimestamp != null) {
      return {
        kind: 'absolute',
        from: oldestTimestamp,
        to: new Date().toISOString()
      };
    } else {
      const {
        to,
        from,
        fromStr,
        toStr
      } = (0, _default_date_settings.getTimeRangeSettings)();
      return {
        kind: 'relative',
        to,
        from,
        fromStr,
        toStr
      };
    }
  }, [oldestTimestamp, relativeTimerange]);
  if (isQueryLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 12
      }
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_investigate_in_timeline_button.InvestigateInTimelineButton, {
      asEmptyButton: false,
      isDisabled: hasError,
      dataProviders: dataProviders,
      filters: filters,
      timeRange: timerange,
      keepDataView: true,
      "data-test-subj": "insight-investigate-in-timeline-button",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "timeline",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 11
      }
    }), ` ${label} (${(0, _numeral.default)(totalCount).format(resultFormat)})`), /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 9
      }
    }, description));
  }
};

// receives the configuration from the parser and renders
const InsightComponent = ({
  label,
  description,
  providers,
  relativeFrom,
  relativeTo
}) => {
  const insightsUpsellingMessage = (0, _use_upselling.useUpsellingMessage)('investigation_guide');
  if (insightsUpsellingMessage) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: insightsUpsellingMessage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: true,
      iconSide: 'left',
      iconType: 'timeline',
      "data-test-subj": "insight-investigate-in-timeline-button",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 11
      }
    }, `${label}`)), /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 9
      }
    }, description));
  } else {
    return /*#__PURE__*/_react.default.createElement(LicensedInsightComponent, {
      label: label,
      description: description,
      providers: providers,
      relativeFrom: relativeFrom,
      relativeTo: relativeTo,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 267,
        columnNumber: 7
      }
    });
  }
};
exports.renderer = InsightComponent;
const InsightEditorComponent = ({
  node,
  onSave,
  onCancel
}) => {
  const isEditMode = node != null;
  const {
    sourcererDataView: oldSourcererDataView
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.default);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.default);
  const dataViewName = newDataViewPickerEnabled ? experimentalDataView.name : oldSourcererDataView.name;
  const {
    unifiedSearch: {
      ui: {
        FiltersBuilderLazy
      }
    },
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const oldDataView = (0, _use_get_sourcerer_data_view.useGetScopedSourcererDataView)({
    sourcererScope: _model.SourcererScopeName.default
  });
  const dataView = newDataViewPickerEnabled ? experimentalDataView : oldDataView;
  const [providers, setProviders] = (0, _react.useState)([[]]);
  const dateRangeChoices = (0, _react.useMemo)(() => {
    const settings = uiSettings.get(_constants.DEFAULT_TIMEPICKER_QUICK_RANGES);
    const emptyValue = {
      value: '0',
      text: ''
    };
    return [emptyValue, ...settings.map(({
      display
    }, index) => {
      return {
        value: String(index),
        text: display
      };
    })];
  }, [uiSettings]);
  const formMethods = (0, _reactHookForm.useForm)({
    defaultValues: {
      label: node === null || node === void 0 ? void 0 : node.label,
      description: node === null || node === void 0 ? void 0 : node.description,
      relativeTimerange: (node === null || node === void 0 ? void 0 : node.relativeTimerange) || '0'
    },
    shouldUnregister: true
  });
  const labelController = (0, _reactHookForm.useController)({
    name: 'label',
    control: formMethods.control
  });
  const descriptionController = (0, _reactHookForm.useController)({
    name: 'description',
    control: formMethods.control
  });
  const relativeTimerangeController = (0, _reactHookForm.useController)({
    name: 'relativeTimerange',
    control: formMethods.control
  });
  const getTimeRangeSelection = (0, _react.useCallback)(selection => {
    const selectedOption = dateRangeChoices.find(option => {
      return option.value === selection;
    });
    if (selectedOption && selectedOption.value !== '0') {
      const settingsIndex = Number(selectedOption.value);
      const settings = uiSettings.get(_constants.DEFAULT_TIMEPICKER_QUICK_RANGES);
      return {
        relativeFrom: settings[settingsIndex].from,
        relativeTo: settings[settingsIndex].to
      };
    } else {
      return {};
    }
  }, [dateRangeChoices, uiSettings]);
  const onSubmit = (0, _react.useCallback)(() => {
    onSave(`${insightPrefix}${JSON.stringify((0, _lodash.pickBy)({
      label: labelController.field.value,
      description: descriptionController.field.value,
      providers,
      ...getTimeRangeSelection(relativeTimerangeController.field.value)
    }, value => !(0, _lodash.isEmpty)(value)))}}`, {
      block: true
    });
  }, [onSave, providers, labelController.field.value, descriptionController.field.value, relativeTimerangeController.field.value, getTimeRangeSelection]);
  const onChange = (0, _react.useCallback)(filters => {
    setProviders((0, _provider.filtersToInsightProviders)(filters));
  }, []);
  const selectOnChange = (0, _react.useCallback)(event => {
    relativeTimerangeController.field.onChange(event.target.value);
  }, [relativeTimerangeController.field]);
  const disableSubmit = (0, _react.useMemo)(() => {
    var _labelController$fiel;
    const labelOrEmpty = (_labelController$fiel = labelController.field.value) !== null && _labelController$fiel !== void 0 ? _labelController$fiel : '';
    const flattenedProviders = providers.flat();
    return labelOrEmpty.trim() === '' || flattenedProviders.length === 0 || flattenedProviders.some(provider => !(0, _helpers.isProviderValid)(provider, dataView === null || dataView === void 0 ? void 0 : dataView.getFieldByName(provider.field)));
  }, [labelController.field.value, providers, dataView]);
  const filtersStub = (0, _react.useMemo)(() => {
    const index = dataViewName !== null && dataViewName !== void 0 ? dataViewName : '*';
    return [{
      $state: {
        store: _esQuery.FilterStateStore.APP_STATE
      },
      meta: {
        disabled: false,
        negate: false,
        alias: null,
        index
      }
    }];
  }, [dataViewName]);
  const isPlatinum = (0, _use_license.useLicense)().isAtLeast('platinum');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    css: (0, _react2.css)`
          min-width: 700px;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 437,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 442,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 443,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 444,
      columnNumber: 13
    }
  }, isEditMode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.insight.editModalTitle",
    defaultMessage: "Edit investigation query",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 446,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.insight.addModalTitle",
    defaultMessage: "Add investigation query",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 451,
      columnNumber: 17
    }
  }))))), isPlatinum === false && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "To add suggested queries to an investigation guide, please upgrade to platinum",
    iconType: "timeline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 461,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 466,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, formMethods, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 467,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 468,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.FORM_DESCRIPTION,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 469,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.LABEL,
    helpText: i18n.LABEL_TEXT,
    isInvalid: labelController.field.value !== undefined && labelController.field.value.trim().length === 0,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 472,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    isInvalid: labelController.field.value !== undefined && labelController.field.value.trim().length === 0
  }, formMethods.register('label'), {
    ref: null,
    name: "label",
    onChange: labelController.field.onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 481,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.DESCRIPTION,
    helpText: i18n.DESCRIPTION_TEXT,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 494,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, formMethods.register('description'), {
    ref: null,
    name: "description",
    onChange: descriptionController.field.onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 495,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.FILTER_BUILDER,
    helpText: i18n.FILTER_BUILDER_TEXT,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 501,
      columnNumber: 13
    }
  }, dataView ? /*#__PURE__*/_react.default.createElement(FiltersBuilderLazy, {
    filters: filtersStub,
    onChange: onChange,
    dataView: dataView,
    maxDepth: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 503,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.RELATIVE_TIMERANGE,
    helpText: i18n.RELATIVE_TIMERANGE_TEXT,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 513,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({}, formMethods.register('relativeTimerange'), {
    ref: null,
    onChange: selectOnChange,
    options: dateRangeChoices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 518,
      columnNumber: 15
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 528,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 529,
      columnNumber: 9
    }
  }, i18n.CANCEL_FORM_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: formMethods.handleSubmit(onSubmit),
    fill: true,
    disabled: disableSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 530,
      columnNumber: 9
    }
  }, isEditMode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.insight.addModalConfirmButtonLabel",
    defaultMessage: "Add query",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 532,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.insight.editModalConfirmButtonLabel",
    defaultMessage: "Save changes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 537,
      columnNumber: 13
    }
  }))));
};
const InsightEditor = /*#__PURE__*/_react.default.memo(InsightEditorComponent);
const exampleInsight = `${insightPrefix}{
  "label": "Test action",
  "description": "Click to investigate",
  "providers": [
    [
      {"field": "event.id", "value": "{{kibana.alert.original_event.id}}", "queryType": "phrase", "excluded": "false"}
    ],
    [
      {"field": "event.action", "value": "", "queryType": "exists", "excluded": "false"},
      {"field": "process.pid", "value": "{{process.pid}}", "queryType": "phrase", "excluded":"false"}
    ]
  ]
}}`;
const plugin = ({
  insightsUpsellingMessage
}) => {
  return {
    name: 'insights',
    button: {
      label: insightsUpsellingMessage !== null && insightsUpsellingMessage !== void 0 ? insightsUpsellingMessage : i18n.INVESTIGATE,
      iconType: 'timelineWithArrow',
      isDisabled: !!insightsUpsellingMessage
    },
    helpText: /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 572,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "md",
      fontSize: "l",
      paddingSize: "s",
      isCopyable: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 573,
        columnNumber: 9
      }
    }, exampleInsight), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 576,
        columnNumber: 9
      }
    })),
    editor: InsightEditor
  };
};
exports.plugin = plugin;