"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryViewSelector = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-utils-plugin/public");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _constants = require("../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/events_viewer/summary_view_select/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const storage = new _public.Storage(localStorage);
const ContainerEuiSelectable = _styledComponents.default.div`
  width: 300px;
  .euiSelectableListItem__text {
    white-space: pre-wrap !important;
    line-height: normal;
  }
`;
const gridView = _i18n.i18n.translate('xpack.securitySolution.selector.summaryView.gridView.label', {
  defaultMessage: 'Grid view'
});
const eventRenderedView = _i18n.i18n.translate('xpack.securitySolution.selector.summaryView.eventRendererView.label', {
  defaultMessage: 'Event rendered view'
});
const SummaryViewSelectorComponent = ({
  viewSelected,
  onViewChange
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => setIsPopoverOpen(currentVal => !currentVal), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const onChangeSelectable = (0, _react.useCallback)(opts => {
    var _selected$0$key, _selected$;
    const selected = opts.filter(i => i.checked === 'on');
    storage.set(_constants.ALERTS_TABLE_VIEW_SELECTION_KEY, (_selected$0$key = (_selected$ = selected[0]) === null || _selected$ === void 0 ? void 0 : _selected$.key) !== null && _selected$0$key !== void 0 ? _selected$0$key : 'gridView');
    if (selected.length > 0) {
      var _selected$0$key2, _selected$2;
      onViewChange((_selected$0$key2 = (_selected$2 = selected[0]) === null || _selected$2 === void 0 ? void 0 : _selected$2.key) !== null && _selected$0$key2 !== void 0 ? _selected$0$key2 : 'gridView');
    }
    setIsPopoverOpen(false);
  }, [onViewChange]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "arrowDown",
    iconSide: "right",
    iconSize: "s",
    onClick: onButtonClick,
    size: "xs",
    flush: "both",
    css: {
      fontWeight: 'normal'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, viewSelected === 'gridView' ? gridView : eventRenderedView), [onButtonClick, viewSelected]);
  const options = (0, _react.useMemo)(() => [{
    label: gridView,
    'data-test-subj': 'gridView',
    key: 'gridView',
    checked: viewSelected === 'gridView' ? 'on' : undefined,
    meta: [{
      text: _i18n.i18n.translate('xpack.securitySolution.selector.summaryView.options.default.description', {
        defaultMessage: 'View as tabular data with the ability to group and sort by specific fields'
      })
    }]
  }, {
    label: eventRenderedView,
    'data-test-subj': 'eventRenderedView',
    key: 'eventRenderedView',
    checked: viewSelected === 'eventRenderedView' ? 'on' : undefined,
    meta: [{
      text: _i18n.i18n.translate('xpack.securitySolution.selector.summaryView.options.summaryView.description', {
        defaultMessage: 'View a rendering of the event flow for each alert'
      })
    }]
  }], [viewSelected]);
  const renderOption = (0, _react.useCallback)(option => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h6", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 11
      }
    }, option.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("small", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 11
      }
    }, option.meta[0].text)));
  }, []);
  const listProps = (0, _react.useMemo)(() => ({
    rowHeight: 80,
    showIcons: true
  }), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ContainerEuiSelectable, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: options,
    onChange: onChangeSelectable,
    renderOption: renderOption,
    searchable: false,
    height: 160,
    listProps: listProps,
    singleSelection: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }, list => list)));
};
const SummaryViewSelector = exports.SummaryViewSelector = /*#__PURE__*/_react.default.memo(SummaryViewSelectorComponent);