"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResponderActionItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _user_privileges = require("../../../user_privileges");
var _use_responder_action_data = require("./use_responder_action_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/endpoint/responder/from_alerts/use_responder_action_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useResponderActionItem = (eventDetailsData, onClick) => {
  const {
    loading: isAuthzLoading,
    canAccessResponseConsole
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    handleResponseActionsClick,
    isDisabled,
    tooltip
  } = (0, _use_responder_action_data.useWithResponderActionDataFromAlert)({
    onClick,
    eventData: eventDetailsData
  });
  return (0, _react.useMemo)(() => {
    const actions = [];
    if (!isAuthzLoading && canAccessResponseConsole) {
      actions.push({
        key: 'endpointResponseActions-action-item',
        'data-test-subj': 'endpointResponseActions-action-item',
        disabled: isDisabled,
        toolTipContent: tooltip,
        size: 's',
        onClick: handleResponseActionsClick,
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.detections.takeAction.responseActionConsole.buttonLabel",
          defaultMessage: "Respond",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 38,
            columnNumber: 11
          }
        })
      });
    }
    return actions;
  }, [canAccessResponseConsole, handleResponseActionsClick, isAuthzLoading, isDisabled, tooltip]);
};
exports.useResponderActionItem = useResponderActionItem;