"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tactic = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _axis_tick = require("../axis_tick");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/attack_discovery_panel/tabs/attack_discovery_tab/attack/attack_chain/tactic/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INNER_CIRCLE_LEFT_JUSTIFY_X_OFFSET = 0; // px
const OUTER_CIRCLE_LEFT_JUSTIFY_X_OFFSET = -4; // px

const TacticComponent = ({
  detected,
  tactic
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const WIDTH = 144; // px
  const TICK_COUNT = 12;
  const ticks = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    "data-tests-subj": "ticks",
    gutterSize: "none",
    responsive: false,
    wrap: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
            overflow: hidden;
            width: ${WIDTH}px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 9
    }
  }), Array.from({
    length: TICK_COUNT
  }).map((_, i) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    key: i,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_axis_tick.AxisTick, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 13
    }
  })))), []);
  const color = detected ? euiTheme.colors.danger : euiTheme.colors.subduedText;
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        width: ${WIDTH}px;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "tactic",
    direction: "column",
    gutterSize: "none",
    responsive: false,
    wrap: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
            position: relative;
          `,
    "data-test-subj": "tics",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    // eslint-disable-next-line @elastic/eui/no-css-color -- euiTheme.colors.danger is a string
    css: (0, _react.css)`
              background: transparent;
              border: 2px solid ${color};
              border-radius: 50%;
              height: 8px;
              position: absolute;
              transform: translate(${INNER_CIRCLE_LEFT_JUSTIFY_X_OFFSET}px, -2px);
              width: 8px;
            `,
    "data-test-subj": "innerCircle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement("div", {
    // eslint-disable-next-line @elastic/eui/no-css-color -- euiTheme.colors.danger is a string
    css: (0, _react.css)`
              background: transparent;
              border: 2px solid ${color};
              border-radius: 50%;
              height: 16px;
              opacity: ${detected ? 25 : 0}%;
              position: absolute;
              transform: translate(${OUTER_CIRCLE_LEFT_JUSTIFY_X_OFFSET}px, -6px);
              width: 16px;
            `,
    "data-test-subj": "outerCircle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, ticks)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
            position: relative;
          `,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
            position: relative;
          `,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: color,
    "data-test-subj": "tacticText",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }, tactic))));
};
TacticComponent.displayName = 'Tactic';
const Tactic = exports.Tactic = /*#__PURE__*/_react2.default.memo(TacticComponent);