"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SharedBadge = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _fp = require("lodash/fp");
var _react2 = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _use_attack_discovery_bulk = require("../../../../../../use_attack_discovery_bulk");
var _use_find_attack_discoveries = require("../../../../../../use_find_attack_discoveries");
var _is_attack_discovery_alert = require("../../../../../../utils/is_attack_discovery_alert");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/attack_discovery_panel/panel_header/primary_interactions/badges/shared_badge/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LIST_PROPS = {
  isVirtualized: false,
  rowHeight: 60
};
const SharedBadgeComponent = ({
  attackDiscovery
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const invalidateFindAttackDiscoveries = (0, _use_find_attack_discoveries.useInvalidateFindAttackDiscoveries)();
  const onBadgeButtonClick = (0, _react2.useCallback)(() => {
    setIsPopoverOpen(isOpen => !isOpen);
  }, []);
  const closePopover = (0, _react2.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const filterGroupPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'visibilityFilterGroupPopover'
  });
  const isShared = (0, _react2.useMemo)(() => {
    if (!(0, _is_attack_discovery_alert.isAttackDiscoveryAlert)(attackDiscovery)) {
      return false;
    }
    if ((0, _fp.isEmpty)(attackDiscovery.users)) {
      return true;
    }
    return attackDiscovery.users != null && attackDiscovery.users.length > 1;
  }, [attackDiscovery]);
  const [items, setItems] = (0, _react2.useState)([{
    checked: !isShared ? 'on' : undefined,
    data: {
      description: i18n.ONLY_VISIBLE_TO_YOU
    },
    'data-test-subj': 'notShared',
    disabled: isShared,
    label: i18n.NOT_SHARED
  }, {
    checked: isShared ? 'on' : undefined,
    data: {
      description: i18n.VISIBLE_TO_YOUR_TEAM
    },
    'data-test-subj': 'shared',
    disabled: isShared,
    label: i18n.SHARED
  }]);
  const selectedLabel = (0, _react2.useMemo)(() => {
    const firstSelected = items.find(item => item.checked === 'on');
    return firstSelected != null ? firstSelected.label : items[0].label;
  }, [items]);
  const renderOption = (0, _react2.useCallback)(option => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
          height: 53px;
          width: 132px;
        `,
    direction: "column",
    gutterSize: "none",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
              font-weight: bold;
            `,
    "data-test-subj": "optionLabel",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, option.label)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    "data-test-subj": "optionDescription",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }, option.description))), []);
  const button = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    "aria-label": i18n.VISIBILITY,
    color: "hollow",
    "data-test-subj": "sharedBadgeButton",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: onBadgeButtonClick,
    onClickAriaLabel: i18n.SELECT_VISIBILITY_ARIA_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, selectedLabel), [onBadgeButtonClick, selectedLabel]);
  const {
    mutateAsync: attackDiscoveryBulk
  } = (0, _use_attack_discovery_bulk.useAttackDiscoveryBulk)();
  const onSelectableChange = (0, _react2.useCallback)(async newOptions => {
    setItems(newOptions);
    if ((0, _is_attack_discovery_alert.isAttackDiscoveryAlert)(attackDiscovery)) {
      const visibility = newOptions[0].checked === 'on' ? 'not_shared' : 'shared';
      await attackDiscoveryBulk({
        ids: [attackDiscovery.id],
        visibility
      });

      // disable all options if the new visibility is 'shared'
      if (visibility === 'shared') {
        setItems(newOptions.map(item => ({
          ...item,
          disabled: true // prevent further changes
        })));
      }
      invalidateFindAttackDiscoveries();
    }
  }, [attackDiscovery, attackDiscoveryBulk, invalidateFindAttackDiscoveries]);
  const allItemsDisabled = (0, _react2.useMemo)(() => items.every(item => item.disabled), [items]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: isPopoverOpen && allItemsDisabled ? i18n.THE_VISIBILITY_OF_SHARED : undefined,
    "data-test-subj": "sharedBadgeTooltip",
    position: "top",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    button: button,
    closePopover: closePopover,
    "data-test-subj": "sharedBadgePopover",
    id: filterGroupPopoverId,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSelectable, {
    "aria-label": i18n.VISIBILITY,
    "data-test-subj": "sharedBadge",
    listProps: LIST_PROPS,
    options: items,
    onChange: onSelectableChange,
    renderOption: renderOption,
    singleSelection: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 9
    }
  }, list => /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
                width: 230px;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 13
    }
  }, list))));
};
const SharedBadge = exports.SharedBadge = /*#__PURE__*/_react2.default.memo(SharedBadgeComponent);