"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useElasticAssistantSharedStateSignalIndex = void 0;
var _react = require("react");
var _kibana = require("../../common/lib/kibana");
var _use_signal_index = require("../../detections/containers/detection_engine/alerts/use_signal_index");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useElasticAssistantSharedStateSignalIndex = () => {
  const {
    elasticAssistantSharedState
  } = (0, _kibana.useKibana)().services;
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  (0, _react.useEffect)(() => {
    if (!signalIndexName) {
      return elasticAssistantSharedState.signalIndex.setSignalIndex(undefined);
    }
    elasticAssistantSharedState.signalIndex.setSignalIndex(signalIndexName); // setSignalIndex returns a function to unset the signal index. We don't unset the signal index here so that the signal index is present when the assistant is invoked outside of the security solution.
  }, [signalIndexName, elasticAssistantSharedState]);
};
exports.useElasticAssistantSharedStateSignalIndex = useElasticAssistantSharedStateSignalIndex;