"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityGroupName = exports.SECURITY_UI_APP_ID = exports.LinkCategoryType = void 0;
Object.defineProperty(exports, "SecurityPageName", {
  enumerable: true,
  get: function () {
    return _deeplinksSecurity.SecurityPageName;
  }
});
var _deeplinksSecurity = require("@kbn/deeplinks-security");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECURITY_UI_APP_ID = exports.SECURITY_UI_APP_ID = 'securitySolutionUI';
let LinkCategoryType = exports.LinkCategoryType = /*#__PURE__*/function (LinkCategoryType) {
  LinkCategoryType["title"] = "title";
  LinkCategoryType["collapsibleTitle"] = "collapsibleTitle";
  LinkCategoryType["accordion"] = "accordion";
  LinkCategoryType["separator"] = "separator";
  return LinkCategoryType;
}({});
/**
 * Navigation group names.
 * They are nodes used to group links in the navigationTree but don't have a page on their own.
 * All values need to have the "securityGroup:" prefix to avoid collisions with regular `SecurityPageName`
 * since they are mixed together in the navigationTree.
 */
let SecurityGroupName = exports.SecurityGroupName = /*#__PURE__*/function (SecurityGroupName) {
  SecurityGroupName["rules"] = "securityGroup:rules";
  SecurityGroupName["explore"] = "securityGroup:explore";
  SecurityGroupName["investigations"] = "securityGroup:investigations";
  SecurityGroupName["assets"] = "securityGroup:assets";
  SecurityGroupName["entityAnalytics"] = "securityGroup:entityAnalytics";
  SecurityGroupName["machineLearning"] = "securityGroup:machineLearning";
  SecurityGroupName["launchpad"] = "securityGroup:launchpad";
  return SecurityGroupName;
}({});