"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterComboBox = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/privileges/es/remote_clusters_combo_box.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const API_KEY_SECURITY_MODEL = 'api_key';
const RemoteClusterComboBox = ({
  remoteClusters,
  type,
  ...restProps
}) => {
  const remoteClusterOptions = (0, _react.useMemo)(() => {
    const {
      incompatible,
      remote
    } = remoteClusters.reduce((data, item) => {
      const disabled = item.securityModel !== API_KEY_SECURITY_MODEL;
      if (!disabled) {
        data.remote.push({
          label: item.name
        });
        return data;
      }
      data.incompatible.push({
        label: item.name,
        disabled,
        append: disabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          type: "warning",
          color: "inherit",
          content: type === 'remote_cluster' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.management.editRole.remoteClusterPrivilegeForm.remoteClusterSecurityModelWarning",
            defaultMessage: "This cluster is configured with the certificate based security model and does not support remote cluster privileges. Connect this cluster with the API key based security model instead to use remote cluster privileges.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 50,
              columnNumber: 19
            }
          }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.management.editRole.indexPrivilegeForm.remoteIndicesSecurityModelWarning",
            defaultMessage: "This cluster is configured with the certificate based security model and does not support remote index privileges. Connect this cluster with the API key based security model instead to use remote index privileges.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 55,
              columnNumber: 19
            }
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 45,
            columnNumber: 13
          }
        }) : undefined
      });
      return data;
    }, {
      incompatible: [],
      remote: []
    });
    if (incompatible.length) {
      remote.push({
        label: 'Incompatible clusters',
        isGroupLabelOption: true
      }, ...incompatible);
    }
    return remote;
  }, [remoteClusters, type]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, restProps, {
    options: remoteClusterOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 10
    }
  }));
};
exports.RemoteClusterComboBox = RemoteClusterComboBox;