"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRulesSets = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api_routes = require("../../../common/api_routes");
var _pagination = require("../../../common/pagination");
var _use_fetch_query_rules_sets = require("../../hooks/use_fetch_query_rules_sets");
var _use_kibana = require("../../hooks/use_kibana");
var _use_query_rules_sets_table_data = require("../../hooks/use_query_rules_sets_table_data");
var _query_rules_sets_search = require("./query_rules_sets_search");
var _delete_ruleset_modal = require("./delete_ruleset_modal");
var _use_run_query_ruleset = require("../../hooks/use_run_query_ruleset");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _constants = require("../../analytics/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_query_rules/public/components/query_rules_sets/query_rules_sets.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const QueryRulesSets = () => {
  const useTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    services: {
      application,
      http
    }
  } = (0, _use_kibana.useKibana)();
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(_pagination.DEFAULT_PAGE_VALUE.size);
  const [searchKey, setSearchKey] = (0, _react.useState)('');
  const {
    from
  } = (0, _pagination.paginationToPage)({
    pageIndex,
    pageSize,
    totalItemCount: 0
  });
  const {
    data: queryRulesData
  } = (0, _use_fetch_query_rules_sets.useFetchQueryRulesSets)({
    from,
    size: pageSize
  });
  const [rulesetToDelete, setRulesetToDelete] = (0, _react.useState)(null);
  const {
    queryRulesSetsFilteredData,
    pagination
  } = (0, _use_query_rules_sets_table_data.useQueryRulesSetsTableData)(queryRulesData, searchKey, pageIndex, pageSize);
  (0, _react.useEffect)(() => {
    var _useTracker$load;
    useTracker === null || useTracker === void 0 ? void 0 : (_useTracker$load = useTracker.load) === null || _useTracker$load === void 0 ? void 0 : _useTracker$load.call(useTracker, _constants.AnalyticsEvents.rulesetListPageLoaded);
  }, [useTracker]);
  if (!queryRulesData) {
    return null;
  }
  const columns = [{
    field: 'ruleset_id',
    name: _i18n.i18n.translate('xpack.queryRules.queryRulesSetTable.nameColumn', {
      defaultMessage: 'Query Rule Set'
    }),
    render: name => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "queryRuleSetName",
      onClick: () => {
        var _useTracker$click;
        useTracker === null || useTracker === void 0 ? void 0 : (_useTracker$click = useTracker.click) === null || _useTracker$click === void 0 ? void 0 : _useTracker$click.call(useTracker, _constants.AnalyticsEvents.editRulesetInlineNameClicked);
        application.navigateToUrl(http.basePath.prepend(`${_api_routes.PLUGIN_ROUTE_ROOT}/ruleset/${name}`));
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }, name)
  }, {
    field: 'rule_total_count',
    name: _i18n.i18n.translate('xpack.queryRules.queryRulesSetTable.ruleCount', {
      defaultMessage: 'Rule Count'
    }),
    render: ruleCount => /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "queryRuleSetItemRuleCount",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }, ruleCount)
  }, {
    actions: [{
      render: item => {
        return /*#__PURE__*/_react.default.createElement(_use_run_query_ruleset.UseRunQueryRuleset, {
          rulesetId: item.ruleset_id,
          type: "contextMenuItem",
          content: _i18n.i18n.translate('xpack.queryRules.queryRulesSetTable.actions.run', {
            defaultMessage: 'Test in Console'
          }),
          onClick: () => {
            var _useTracker$click2;
            useTracker === null || useTracker === void 0 ? void 0 : (_useTracker$click2 = useTracker.click) === null || _useTracker$click2 === void 0 ? void 0 : _useTracker$click2.call(useTracker, _constants.AnalyticsEvents.testRulesetInlineDropdownClicked);
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 86,
            columnNumber: 15
          }
        });
      }
    }, {
      name: _i18n.i18n.translate('xpack.queryRules.queryRulesSetTable.actions.edit', {
        defaultMessage: 'Edit'
      }),
      description: ruleset => _i18n.i18n.translate('xpack.queryRules.queryRulesSetTable.actions.editDescription', {
        defaultMessage: 'Edit query ruleset {name}',
        values: {
          name: ruleset.ruleset_id
        }
      }),
      icon: 'pencil',
      color: 'text',
      type: 'icon',
      onClick: ruleset => {
        var _useTracker$click3;
        useTracker === null || useTracker === void 0 ? void 0 : (_useTracker$click3 = useTracker.click) === null || _useTracker$click3 === void 0 ? void 0 : _useTracker$click3.call(useTracker, _constants.AnalyticsEvents.editRulesetInlineDropdownClicked);
        application.navigateToUrl(http.basePath.prepend(`${_api_routes.PLUGIN_ROUTE_ROOT}/ruleset/${ruleset.ruleset_id}`));
      }
    }, {
      name: _i18n.i18n.translate('xpack.queryRules.queryRulesSetTable.actions.delete', {
        defaultMessage: 'Delete'
      }),
      description: ruleset => _i18n.i18n.translate('xpack.queryRules.queryRulesSetTable.actions.deleteDescription', {
        defaultMessage: 'Delete query ruleset {name}',
        values: {
          name: ruleset.ruleset_id
        }
      }),
      icon: 'trash',
      color: 'danger',
      type: 'icon',
      'data-test-subj': 'queryRulesSetDeleteButton',
      isPrimary: true,
      onClick: ruleset => {
        var _useTracker$click4;
        useTracker === null || useTracker === void 0 ? void 0 : (_useTracker$click4 = useTracker.click) === null || _useTracker$click4 === void 0 ? void 0 : _useTracker$click4.call(useTracker, _constants.AnalyticsEvents.deleteRulesetInlineDropdownClicked);
        setRulesetToDelete(ruleset.ruleset_id);
      }
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, rulesetToDelete && /*#__PURE__*/_react.default.createElement(_delete_ruleset_modal.DeleteRulesetModal, {
    rulesetId: rulesetToDelete,
    closeDeleteModal: () => setRulesetToDelete(null),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_query_rules_sets_search.QueryRulesSetsSearch, {
    searchKey: searchKey,
    setSearchKey: setSearchKey,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "queryRulesSetTable",
    items: queryRulesSetsFilteredData // Use filtered data from hook
    ,
    columns: columns,
    pagination: pagination,
    onChange: ({
      page: changedPage
    }) => {
      setPageIndex(changedPage.index);
      setPageSize(changedPage.size);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }))));
};
exports.QueryRulesSets = QueryRulesSets;