"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewCodeFlyout = exports.ES_CLIENT_DETAILS = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _constants = require("../../analytics/constants");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _types = require("../../types");
var _use_kibana = require("../../hooks/use_kibana");
var _routes = require("../../../common/routes");
var _py_langchain_python = require("./examples/py_langchain_python");
var _py_lang_client = require("./examples/py_lang_client");
var _dev_tools = require("./examples/dev_tools");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/view_code/view_code_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ES_CLIENT_DETAILS = elasticsearchUrl => {
  return `
es_client = Elasticsearch(
    "${elasticsearchUrl || '<your-elasticsearch-url>'}",
    api_key=os.environ["ES_API_KEY"]
)
      `;
};
exports.ES_CLIENT_DETAILS = ES_CLIENT_DETAILS;
const ViewCodeFlyout = ({
  onClose,
  selectedPageMode
}) => {
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const [selectedLanguage, setSelectedLanguage] = (0, _react.useState)('py-es-client');
  const {
    getValues,
    formState: {
      errors: formErrors
    }
  } = (0, _reactHookForm.useFormContext)();
  const formValues = getValues();
  const {
    services: {
      cloud,
      http
    }
  } = (0, _use_kibana.useKibana)();
  const [elasticsearchUrl, setElasticsearchUrl] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    cloud === null || cloud === void 0 ? void 0 : cloud.fetchElasticsearchConfig().then(config => {
      setElasticsearchUrl(config.elasticsearchUrl || '');
    });
  }, [cloud]);
  const CLIENT_STEP = ES_CLIENT_DETAILS(elasticsearchUrl);
  const steps = {
    'lc-py': /*#__PURE__*/_react.default.createElement(_py_langchain_python.LangchainPythonExmaple, {
      formValues: formValues,
      formErrors: formErrors,
      clientDetails: CLIENT_STEP,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 7
      }
    }),
    'py-es-client': (0, _py_lang_client.PY_LANG_CLIENT)(formValues, formErrors, CLIENT_STEP)
  };
  const handleLanguageChange = e => {
    setSelectedLanguage(e.target.value);
  };
  (0, _react.useEffect)(() => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.viewCodeFlyoutOpened);
  }, [usageTracker]);
  (0, _react.useEffect)(() => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(`${_constants.AnalyticsEvents.viewCodeLanguageChange}_${selectedLanguage}`);
  }, [usageTracker, selectedLanguage]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    "data-test-subj": "viewCodeFlyout",
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewCode.flyout.title",
    defaultMessage: "Application code",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewCode.flyout.subtitle",
    defaultMessage: "Here's the code used to render this search experience. You can integrate it into your own application, modifying as needed.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, selectedPageMode === _types.PlaygroundPageMode.chat && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "view-code-lang-select",
    options: [{
      value: 'py-es-client',
      text: 'Python Elasticsearch Client with OpenAI'
    }, {
      value: 'lc-py',
      text: 'LangChain Python with OpenAI'
    }],
    onChange: handleLanguageChange,
    value: selectedLanguage,
    "aria-label": _i18n.i18n.translate('xpack.searchPlayground.viewCode.languageSelect.ariaLabel', {
      defaultMessage: 'Code language'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    iconType: "popout",
    href: http.basePath.prepend(_routes.MANAGEMENT_API_KEYS),
    "data-test-subj": "viewCodeManageApiKeys",
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewCode.flyout.apiKeysAction",
    defaultMessage: "Manage API Keys",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 21
    }
  }))))), selectedPageMode === _types.PlaygroundPageMode.chat && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 13
    }
  }, steps[selectedLanguage]), selectedPageMode === _types.PlaygroundPageMode.search && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_dev_tools.DevToolsCode, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 15
    }
  })))));
};
exports.ViewCodeFlyout = ViewCodeFlyout;