"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditPlaygroundNameModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _saved_playgrounds = require("../../utils/saved_playgrounds");
var _types = require("../../types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/saved_playground/edit_name_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditPlaygroundNameModal = ({
  playgroundName,
  onClose
}) => {
  const {
    setValue
  } = (0, _reactHookForm.useFormContext)();
  const [name, setName] = (0, _react.useState)(playgroundName);
  const [nameError, setNameError] = (0, _react.useState)(null);
  const modalFormId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'editPlaygroundNameForm'
  });
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const onNameChange = (0, _react.useCallback)(e => {
    setName(e.target.value);
    setNameError((0, _saved_playgrounds.validatePlaygroundName)(e.target.value));
  }, []);
  const onSave = (0, _react.useCallback)(newName => {
    setValue(_types.SavedPlaygroundFormFields.name, newName, {
      shouldDirty: true
    });
    onClose();
  }, [setValue, onClose]);
  const isInvalid = nameError !== null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    initialFocus: "[name=playgroundName]",
    "aria-labelledby": modalTitleId,
    onClose: onClose,
    "data-test-subj": "edit-playground-name-modal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.nameEditModal.title",
    defaultMessage: "Edit playground name",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    id: modalFormId,
    component: "form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.searchPlayground.savedPlayground.nameEditModal.name.label', {
      defaultMessage: 'Name'
    }),
    isInvalid: isInvalid,
    error: nameError ? [nameError] : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "searchPlaygroundEditPlaygroundNameModalFieldText",
    name: "playgroundName",
    value: name,
    onChange: onNameChange,
    isInvalid: isInvalid,
    required: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "searchPlaygroundEditPlaygroundNameModalCancelButton",
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.nameEditModal.cancel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "searchPlaygroundEditPlaygroundNameModalSaveButton",
    type: "submit",
    form: modalFormId,
    disabled: isInvalid,
    onClick: () => onSave(name),
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.nameEditModal.save",
    defaultMessage: "Save",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }))));
};
exports.EditPlaygroundNameModal = EditPlaygroundNameModal;