"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchQueryOutput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _coreHttpBrowser = require("@kbn/core-http-browser");
var _errors = require("../../../common/errors");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/query_mode/query_output.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LOADING_MESSAGE = _i18n.i18n.translate('xpack.searchPlayground.viewQuery.queryOutput.loading.message', {
  defaultMessage: 'Fetching...'
});
const ElasticsearchQueryOutput = ({
  queryResponse,
  isError,
  queryError,
  isLoading
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const respJSON = (0, _react.useMemo)(() => {
    if (isError) {
      if ((0, _coreHttpBrowser.isHttpFetchError)(queryError)) {
        return queryError !== null && queryError !== void 0 && queryError.body ? JSON.stringify(queryError === null || queryError === void 0 ? void 0 : queryError.body, null, 2) : queryError.message;
      }
      return (0, _errors.getErrorMessage)(queryError);
    }
    return queryResponse ? JSON.stringify(queryResponse.searchResponse, null, 2) : undefined;
  }, [isError, queryError, queryResponse]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true,
    css: _styles.FullHeight,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    css: (0, _styles.QueryViewTitlePanel)(euiTheme),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.queryOutput.title",
    defaultMessage: "Query output",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "none",
    css: _styles.PanelFillContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, !!respJSON ? /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    dataTestSubj: "ViewElasticsearchQueryResponse",
    languageId: "json",
    value: isLoading ? LOADING_MESSAGE : respJSON,
    options: {
      automaticLayout: true,
      readOnly: true
    },
    enableFindAction: true,
    fullWidth: true,
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    css: _styles.FullHeight,
    "data-test-subj": "ViewElasticsearchQueryResponseEmptyState",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.queryOutput.emptyPrompt.body",
    defaultMessage: "Run your query above to view the raw JSON output here.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 19
    }
  }))))));
};
exports.ElasticsearchQueryOutput = ElasticsearchQueryOutput;