"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DescriptionListColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/playgrounds_list/empty_state/description_list_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DescriptionListColumn = ({
  title,
  description
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    direction: "column",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    css: {
      textAlign: 'left'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 13
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    textAlign: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 13
    }
  }, description)))));
};
const DescriptionListColumns = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3,
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(DescriptionListColumn, {
    title: _i18n.i18n.translate('xpack.searchPlayground.playgroundsList.emptyPrompt.listItems.abTest.title', {
      defaultMessage: 'A/B test LLMs'
    }),
    description: _i18n.i18n.translate('xpack.searchPlayground.playgroundsList.emptyPrompt.listItems.abTest.description', {
      defaultMessage: 'Playground allows you to A/B test different LLMs from model providers'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(DescriptionListColumn, {
    title: _i18n.i18n.translate('xpack.searchPlayground.playgroundsList.emptyPrompt.listItems.queryRetrievers.title', {
      defaultMessage: 'Experiment with query retrievers'
    }),
    description: _i18n.i18n.translate('xpack.searchPlayground.playgroundsList.emptyPrompt.listItems.queryRetrievers.description', {
      defaultMessage: "We're helping you simplify query construction with newly introduced query retrievers"
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(DescriptionListColumn, {
    title: _i18n.i18n.translate('xpack.searchPlayground.playgroundsList.emptyPrompt.listItems.lowCode.title', {
      defaultMessage: 'Low-code interaction'
    }),
    description: _i18n.i18n.translate('xpack.searchPlayground.playgroundsList.emptyPrompt.listItems.lowCode.description', {
      defaultMessage: "Elastic's Playground experience is a low-code interface"
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }));
};
exports.DescriptionListColumns = DescriptionListColumns;