"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointModelInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _inferenceEndpointUiCommon = require("@kbn/inference-endpoint-ui-common");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_inference_endpoints/public/components/all_inference_endpoints/render_table_columns/render_service_provider/endpoint_model_info.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const descriptions = {
  [_inferenceEndpointUiCommon.ServiceProviderKeys.elastic]: i18n.TOKEN_BASED_BILLING_DESCRIPTION,
  [_inferenceEndpointUiCommon.ServiceProviderKeys.elasticsearch]: i18n.RESOURCE_BASED_BILLING_DESCRIPTION
};
const EndpointModelInfo = ({
  endpointInfo
}) => {
  var _ELASTIC_MODEL_DEFINI, _endpointInfo$service, _ELASTIC_MODEL_DEFINI2;
  const serviceSettings = endpointInfo.service_settings;
  const modelId = 'model_id' in serviceSettings ? serviceSettings.model_id : 'model' in serviceSettings ? serviceSettings.model : undefined;
  const isEligibleForMITBadge = modelId && ((_ELASTIC_MODEL_DEFINI = _mlTrainedModelsUtils.ELASTIC_MODEL_DEFINITIONS[modelId]) === null || _ELASTIC_MODEL_DEFINI === void 0 ? void 0 : _ELASTIC_MODEL_DEFINI.license) === 'MIT';
  const description = endpointInfo !== null && endpointInfo !== void 0 && endpointInfo.inference_id.startsWith('.') ? descriptions[(_endpointInfo$service = endpointInfo === null || endpointInfo === void 0 ? void 0 : endpointInfo.service) !== null && _endpointInfo$service !== void 0 ? _endpointInfo$service : ''] : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, modelId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 15
    }
  }, description !== null && description !== void 0 ? description : modelId)), isEligibleForMITBadge ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    iconType: "popout",
    iconSide: "right",
    href: (_ELASTIC_MODEL_DEFINI2 = _mlTrainedModelsUtils.ELASTIC_MODEL_DEFINITIONS[modelId].licenseUrl) !== null && _ELASTIC_MODEL_DEFINI2 !== void 0 ? _ELASTIC_MODEL_DEFINI2 : '',
    target: "_blank",
    "data-test-subj": 'mit-license-badge',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 17
    }
  }, i18n.MIT_LICENSE)) : null, ' ')), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, endpointModelAtrributes(endpointInfo)));
};
exports.EndpointModelInfo = EndpointModelInfo;
function endpointModelAtrributes(endpoint) {
  switch (endpoint.service) {
    case _inferenceEndpointUiCommon.ServiceProviderKeys.hugging_face:
      return huggingFaceAttributes(endpoint);
    case _inferenceEndpointUiCommon.ServiceProviderKeys.azureaistudio:
      return azureOpenAIStudioAttributes(endpoint);
    case _inferenceEndpointUiCommon.ServiceProviderKeys.azureopenai:
      return azureOpenAIAttributes(endpoint);
    default:
      return null;
  }
}
function huggingFaceAttributes(endpoint) {
  const serviceSettings = endpoint.service_settings;
  const url = 'url' in serviceSettings ? serviceSettings.url : null;
  return url;
}
function azureOpenAIStudioAttributes(endpoint) {
  const serviceSettings = endpoint.service_settings;
  return 'provider' in serviceSettings ? serviceSettings === null || serviceSettings === void 0 ? void 0 : serviceSettings.provider : undefined;
}
function azureOpenAIAttributes(endpoint) {
  const serviceSettings = endpoint.service_settings;
  return 'resource_name' in serviceSettings ? serviceSettings.resource_name : undefined;
}