"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatefulDocumentCountStat = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _quick_stat = require("./quick_stat");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/quick_stats/stateful_document_count_stat.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StatefulDocumentCountStat = ({
  index,
  open,
  setOpen,
  mappingStats
}) => {
  var _index$documents, _index$documents2, _index$documents_dele;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_quick_stat.QuickStat, {
    open: open,
    setOpen: setOpen,
    icon: "documents",
    iconColor: euiTheme.colors.fullShade,
    title: _constants.DOCUMENT_COUNT_LABEL,
    "data-test-subj": "QuickStatsDocumentCount",
    secondaryTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
      value: (_index$documents = index.documents) !== null && _index$documents !== void 0 ? _index$documents : 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 23
      }
    }),
    stats: [{
      title: _constants.TOTAL_COUNT_LABEL,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: (_index$documents2 = index.documents) !== null && _index$documents2 !== void 0 ? _index$documents2 : 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 24
        }
      })
    }, {
      title: _constants.DELETED_COUNT_LABEL,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: (_index$documents_dele = index.documents_deleted) !== null && _index$documents_dele !== void 0 ? _index$documents_dele : 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 52,
          columnNumber: 24
        }
      })
    }],
    tooltipContent: mappingStats.semantic_text > 0 ? _constants.DOCUMENT_COUNT_TOOLTIP : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  });
};
exports.StatefulDocumentCountStat = StatefulDocumentCountStat;