"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexManagementApp = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../hooks/use_kibana");
var _constants = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/index_management/index_management_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchIndexManagementApp = ({
  indexManagement
}) => {
  const {
    history,
    searchNavigation,
    cloud
  } = (0, _use_kibana.useKibana)().services;
  const indexManagementRef = (0, _react.useRef)(null);
  const setBreadcrumbs = (0, _react.useCallback)((crumbs = [], appHistory) => {
    const wrapBreadcrumb = (item, scopedHistory) => ({
      ...item,
      ...(item.href ? (0, _public.reactRouterNavigate)(scopedHistory, item.href) : {})
    });
    const wrapBreadcrumbValue = !(cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled) ? [wrapBreadcrumb(_constants.PARENT_BREADCRUMB, history)] : [];
    const breadcrumbValue = [...wrapBreadcrumbValue, ...crumbs.map(item => wrapBreadcrumb(item, appHistory || history))];
    searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.breadcrumbs.setSearchBreadCrumbs(breadcrumbValue);
  }, [searchNavigation, history, cloud]);
  (0, _react.useEffect)(() => {
    // mount
    let indexManagementUnmount;
    indexManagement.renderIndexManagementApp({
      element: indexManagementRef.current,
      setBreadcrumbs,
      history
    }).then(unmount => {
      indexManagementUnmount = unmount;
    });
    return () => {
      var _indexManagementUnmou;
      // unmount
      (_indexManagementUnmou = indexManagementUnmount) === null || _indexManagementUnmou === void 0 ? void 0 : _indexManagementUnmou();
    };
  }, [indexManagement, indexManagementRef, setBreadcrumbs, history]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    offset: 0,
    restrictWidth: false,
    "data-test-subj": "elasticsearchIndexManagement",
    grow: false,
    solutionNav: searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.useClassicNavigation(history),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: indexManagementRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  })));
};
exports.SearchIndexManagementApp = SearchIndexManagementApp;