"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectedSavedObjectModalTagSelectorComponent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _base = require("../base");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/saved_objects_tagging/public/components/connected/saved_object_save_modal_tag_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getConnectedSavedObjectModalTagSelectorComponent = ({
  cache,
  capabilities,
  openCreateModal
}) => {
  return ({
    initialSelection,
    onTagsSelected: notifySelectionChange,
    markOptional,
    ...rest
  }) => {
    const tags = (0, _useObservable.default)(cache.getState$(), cache.getState());
    const [selected, setSelected] = (0, _react.useState)(initialSelection);
    const [searchValue, setSearchValue] = (0, _react.useState)('');
    const [touched, setTouched] = (0, _react.useState)(false);
    const normalizedSearchValue = searchValue.trim().toLowerCase();
    const exactTagMatch = !!normalizedSearchValue ? tags.find(tag => tag.name.toLowerCase() === normalizedSearchValue) : undefined;
    const isTagAlreadyCreated = !!exactTagMatch;
    const isTagAlreadySelected = isTagAlreadyCreated && selected.includes(exactTagMatch.id);
    const noMatchingTag = !!normalizedSearchValue && !isTagAlreadyCreated;
    const isInvalid = touched && (noMatchingTag || isTagAlreadyCreated || isTagAlreadySelected);
    const getErrorMessage = () => {
      if (isTagAlreadySelected) {
        return _i18n.i18n.translate('xpack.savedObjectsTagging.uiApi.saveModal.alreadySelectedHint', {
          defaultMessage: 'Tag "{searchValue}" is already selected.',
          values: {
            searchValue
          }
        });
      }
      if (isTagAlreadyCreated) {
        return _i18n.i18n.translate('xpack.savedObjectsTagging.uiApi.saveModal.exactTagMatchHint', {
          defaultMessage: 'Tag "{searchValue}" already exists. Select it from the existing tags.',
          values: {
            searchValue
          }
        });
      }
      return capabilities.create ? _i18n.i18n.translate('xpack.savedObjectsTagging.uiApi.saveModal.noMatchingTagCreateHint', {
        defaultMessage: 'No tags match "{searchValue}". Select an existing tag or create a new one.',
        values: {
          searchValue
        }
      }) : _i18n.i18n.translate('xpack.savedObjectsTagging.uiApi.saveModal.noMatchingTagHint', {
        defaultMessage: 'No tags match "{searchValue}".',
        values: {
          searchValue
        }
      });
    };
    const setSelectedInternal = (0, _react.useCallback)(newSelection => {
      setSelected(newSelection);
      notifySelectionChange(newSelection);
    }, [notifySelectionChange]);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.savedObjectsTagging.uiApi.saveModal.label",
        defaultMessage: "Tags",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 11
        }
      }),
      labelAppend: markOptional && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.savedObjectsTagging.uiApi.saveModal.optional",
        defaultMessage: "Optional",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 15
        }
      })),
      isInvalid: isInvalid,
      error: isInvalid ? getErrorMessage() : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_base.TagSelector, (0, _extends2.default)({
      selected: selected,
      onTagsSelected: setSelectedInternal,
      tags: tags,
      "data-test-subj": "savedObjectTagSelector",
      allowCreate: capabilities.create,
      openCreateModal: openCreateModal,
      onSearchChange: setSearchValue,
      onBlur: () => setTouched(true),
      isInvalid: isInvalid
    }, rest, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 9
      }
    })));
  };
};
exports.getConnectedSavedObjectModalTagSelectorComponent = getConnectedSavedObjectModalTagSelectorComponent;