"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IlmPolicyMigrationNeededCallOut = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reportingCommon = require("@kbn/reporting-common");
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _reportingPublic = require("@kbn/reporting-public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/management/components/migrate_ilm_policy_callout/ilm_policy_migration_needed_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const i18nTexts = {
  title: _i18n.i18n.translate('xpack.reporting.listing.ilmPolicyCallout.migrationNeededTitle', {
    defaultMessage: 'Apply new lifecycle policy for reports'
  }),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.reporting.listing.ilmPolicyCallout.migrationNeededDescription",
    defaultMessage: "To ensure your reports are managed consistently, all reporting indices should use the {ilmPolicyName} policy.",
    values: {
      ilmPolicyName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 28,
          columnNumber: 24
        }
      }, _reportingCommon.ILM_POLICY_NAME)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }),
  buttonLabel: _i18n.i18n.translate('xpack.reporting.listing.ilmPolicyCallout.migrateIndicesButtonLabel', {
    defaultMessage: 'Apply {ilmPolicyName} policy',
    values: {
      ilmPolicyName: _reportingCommon.ILM_POLICY_NAME
    }
  }),
  migrateErrorTitle: _i18n.i18n.translate('xpack.reporting.listing.ilmPolicyCallout.migrateIndicesErrorTitle', {
    defaultMessage: 'Could not migrate reporting indices'
  }),
  migrateSuccessTitle: _i18n.i18n.translate('xpack.reporting.listing.ilmPolicyCallout.migrateIndicesSuccessTitle', {
    defaultMessage: 'Reporting policy active for all reporting indices'
  })
};
const IlmPolicyMigrationNeededCallOut = ({
  toasts,
  onMigrationDone
}) => {
  const [isMigratingIndices, setIsMigratingIndices] = (0, _react.useState)(false);
  const isMounted = (0, _useMountedState.default)();
  const {
    apiClient
  } = (0, _reportingPublic.useInternalApiClient)();
  const migrateReportingIndices = async () => {
    try {
      setIsMigratingIndices(true);
      await apiClient.migrateReportingIndicesIlmPolicy();
      onMigrationDone();
      toasts.addSuccess({
        title: i18nTexts.migrateSuccessTitle
      });
    } catch (e) {
      var _e$body;
      toasts.addError(e, {
        title: i18nTexts.migrateErrorTitle,
        toastMessage: (_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.message
      });
    } finally {
      if (isMounted()) setIsMigratingIndices(false);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "migrateReportingIndicesPolicyCallOut",
    title: i18nTexts.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, i18nTexts.description), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "migrateReportingIndicesButton",
    isLoading: isMigratingIndices,
    onClick: migrateReportingIndices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, i18nTexts.buttonLabel));
};
exports.IlmPolicyMigrationNeededCallOut = IlmPolicyMigrationNeededCallOut;