"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostBreakdownChart = HostBreakdownChart;
var _charts = require("@elastic/charts");
var _common = require("@kbn/observability-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_kibana_timezone_setting = require("../../../hooks/use_kibana_timezone_setting");
var _use_profiling_charts_theme = require("../../../hooks/use_profiling_charts_theme");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/views/storage_explorer/host_breakdown/host_breakdown_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function HostBreakdownChart({
  data = []
}) {
  const {
    chartsBaseTheme,
    chartsTheme
  } = (0, _use_profiling_charts_theme.useProfilingChartsTheme)();
  const timeZone = (0, _use_kibana_timezone_setting.useKibanaTimeZoneSetting)();
  const hostBreakdownTimeseries = (0, _react.useMemo)(() => {
    var _data$map;
    return (_data$map = data.map(({
      hostId,
      hostName,
      timeseries
    }) => {
      return {
        data: timeseries !== null && timeseries !== void 0 ? timeseries : [],
        type: 'area',
        title: `${hostName} [${hostId}]`
      };
    })) !== null && _data$map !== void 0 ? _data$map : [];
  }, [data]);
  const xValues = hostBreakdownTimeseries.flatMap(({
    data: timeseriesData
  }) => timeseriesData.map(({
    x
  }) => x));
  const min = Math.min(...xValues);
  const max = Math.max(...xValues);
  const xFormatter = (0, _charts.niceTimeFormatter)([min, max]);
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 400
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: true,
    legendPosition: _charts.Position.Right,
    baseTheme: chartsBaseTheme,
    theme: chartsTheme,
    locale: _i18n.i18n.getLocale(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "x-axis",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: xFormatter,
    gridLine: {
      visible: false
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y-axis",
    position: _charts.Position.Left,
    gridLine: {
      visible: true
    },
    tickFormat: _common.asDynamicBytes,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }), hostBreakdownTimeseries.map(serie => /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    timeZone: timeZone,
    key: serie.title,
    id: serie.title
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    data: serie.data,
    stackAccessors: ['x'],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  })));
}