"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StackTracesView = StackTracesView;
var _react = _interopRequireWildcard(require("react"));
var _ebtTools = require("@kbn/ebt-tools");
var _topn = require("../../../common/topn");
var _use_profiling_dependencies = require("../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _profiling_app_page_template = require("../../components/profiling_app_page_template");
var _stack_traces = require("../../components/stack_traces");
var _use_profiling_params = require("../../hooks/use_profiling_params");
var _use_profiling_router = require("../../hooks/use_profiling_router");
var _use_profiling_route_path = require("../../hooks/use_profiling_route_path");
var _use_time_range = require("../../hooks/use_time_range");
var _use_time_range_async = require("../../hooks/use_time_range_async");
var _route_breadcrumb = require("../../routing/route_breadcrumb");
var _get_stack_traces_tabs = require("./get_stack_traces_tabs");
var _utils = require("./utils");
var _use_async = require("../../hooks/use_async");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/views/stack_traces_view/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function StackTracesView() {
  var _state$data2;
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  const {
    path,
    query,
    path: {
      topNType
    },
    query: {
      rangeFrom,
      rangeTo,
      kuery,
      displayAs,
      limit: limitFromQueryParams
    }
  } = (0, _use_profiling_params.useProfilingParams)('/stacktraces/{topNType}');
  const limit = limitFromQueryParams || 10;
  const tabs = (0, _get_stack_traces_tabs.getStackTracesTabs)({
    path,
    query,
    profilingRouter
  });
  const selectedTab = tabs.find(tab => tab.isSelected);
  const {
    services: {
      fetchTopN
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const state = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    if (!topNType) {
      return Promise.resolve({
        charts: [],
        metadata: {}
      });
    }
    return fetchTopN({
      http,
      type: topNType,
      timeFrom: timeRange.inSeconds.start,
      timeTo: timeRange.inSeconds.end,
      kuery
    }).then(_topn.groupSamplesByCategory);
  }, [topNType, timeRange.inSeconds.start, timeRange.inSeconds.end, fetchTopN, kuery]);
  function onChartClick(category) {
    profilingRouter.push('/stacktraces/{topNType}', (0, _utils.getTracesViewRouteParams)({
      query,
      topNType: path.topNType,
      category
    }));
  }
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  (0, _react.useEffect)(() => {
    if (state.status === _use_async.AsyncStatus.Settled) {
      var _state$data$charts$le, _state$data;
      onPageReady({
        meta: {
          rangeFrom,
          rangeTo
        },
        customMetrics: {
          key1: 'totalCount',
          value1: (_state$data$charts$le = (_state$data = state.data) === null || _state$data === void 0 ? void 0 : _state$data.charts.length) !== null && _state$data$charts$le !== void 0 ? _state$data$charts$le : 0
        }
      });
    }
  }, [state.status, (_state$data2 = state.data) === null || _state$data2 === void 0 ? void 0 : _state$data2.charts.length, onPageReady, rangeFrom, rangeTo]);
  return /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
    title: (selectedTab === null || selectedTab === void 0 ? void 0 : selectedTab.label) || '',
    href: (selectedTab === null || selectedTab === void 0 ? void 0 : selectedTab.href) || '',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
    tabs: tabs,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_stack_traces.StackTraces, {
    type: topNType,
    state: state,
    displayOption: displayAs,
    limit: limit,
    onChartClick: onChartClick,
    onChangeDisplayOption: nextValue => {
      profilingRouter.push(routePath, {
        path,
        query: {
          ...query,
          displayAs: nextValue
        }
      });
    },
    onStackedBarChartBrushEnd: nextRange => {
      profilingRouter.push(routePath, {
        path,
        query: {
          ...query,
          rangeFrom: nextRange.rangeFrom,
          rangeTo: nextRange.rangeTo
        }
      });
    },
    onShowMoreClick: () => {
      profilingRouter.push(routePath, {
        path,
        query: {
          ...query,
          limit: limit + 10
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  })));
}