"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComparisonMode = void 0;
exports.NormalizationMenu = NormalizationMenu;
exports.NormalizationMode = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/normalization_menu/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let ComparisonMode = exports.ComparisonMode = /*#__PURE__*/function (ComparisonMode) {
  ComparisonMode["Absolute"] = "absolute";
  ComparisonMode["Relative"] = "relative";
  return ComparisonMode;
}({});
let NormalizationMode = exports.NormalizationMode = /*#__PURE__*/function (NormalizationMode) {
  NormalizationMode["Scale"] = "scale";
  NormalizationMode["Time"] = "time";
  return NormalizationMode;
}({});
const SCALE_LABEL = _i18n.i18n.translate('xpack.profiling.normalizationMenu.scale', {
  defaultMessage: 'Scale factor'
});
const TIME_LABEL = _i18n.i18n.translate('xpack.profiling.normalizationMenu.time', {
  defaultMessage: 'Time'
});
const NORMALIZE_BY_LABEL = _i18n.i18n.translate('xpack.profiling.normalizationMenu.normalizeBy', {
  defaultMessage: 'Normalize by'
});
function NormalizationMenu(props) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const theme = (0, _eui.useEuiTheme)();
  const baselineScaleFactorInputId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'baselineScaleFactor'
  });
  const comparisonScaleFactorInputId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'comparisonScaleFactor'
  });
  const [mode, setMode] = (0, _react2.useState)(props.mode);
  const [options, setOptions] = (0, _react2.useState)(props.options);
  (0, _react2.useEffect)(() => {
    setMode(props.mode);
    setOptions(props.options);
  }, [props.mode, props.options]);
  const {
    baseline,
    comparison
  } = mode === NormalizationMode.Time ? {
    comparison: options.comparisonTime,
    baseline: options.baselineTime
  } : {
    comparison: options.comparisonScale,
    baseline: options.baselineScale
  };
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    initialFocus: `[id="${baselineScaleFactorInputId}"]`,
    button: /*#__PURE__*/_react2.default.createElement(_eui.EuiFormControlLayout, {
      onClick: () => {
        setIsPopoverOpen(popoverOpen => !popoverOpen);
      },
      compressed: true,
      prepend: NORMALIZE_BY_LABEL,
      append: /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": "profilingNormalizationMenuButton",
        iconType: "arrowDown",
        "aria-label": _i18n.i18n.translate('xpack.profiling.normalizationMenu.menuPopoverButtonAriaLabel', {
          defaultMessage: 'Open normalization menu'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 13
        }
      }),
      css: (0, _react.css)`
            .euiFormLabel {
              max-width: none;
            }
          `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      style: {
        height: '100%',
        justifyContent: 'center',
        backgroundColor: theme.euiTheme.colors.backgroundBasePlain,
        padding: '0 16px'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 11
      }
    }, props.mode === NormalizationMode.Scale ? SCALE_LABEL : TIME_LABEL)),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  }, NORMALIZE_BY_LABEL))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.profiling.normalizationMenu.normalizeByTimeTooltip', {
      defaultMessage: 'Select Normalize by Scale factor and set your Baseline and Comparison scale factors to compare a set of machines of different sizes. For example, you can compare a deployment of 10% of machines to a deployment of 90% of machines.'
    }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.profiling.normalizationMenu.normalizeByScaleTooltip', {
      defaultMessage: 'Select Normalize by Time to compare a set of machines across different time periods. For example, if you compare the last hour to the last 24 hours, the shorter timeframe (1 hour) is multiplied to match the longer timeframe (24 hours).'
    })))),
    position: "right",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonGroup, {
    buttonSize: "compressed",
    isFullWidth: true,
    onChange: (id, value) => {
      setMode(id);
    },
    legend: _i18n.i18n.translate('xpack.profiling.normalizationMode.selectModeLegend', {
      defaultMessage: 'Select a normalization mode for the flamegraph'
    }),
    idSelected: mode,
    options: [{
      id: NormalizationMode.Scale,
      label: SCALE_LABEL
    }, {
      id: NormalizationMode.Time,
      label: TIME_LABEL
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("h6", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.profiling.normalizationMenu.baseline', {
    defaultMessage: 'Baseline'
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    prepend: /*#__PURE__*/_react2.default.createElement(_eui.EuiFormLabel, {
      htmlFor: baselineScaleFactorInputId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 18
      }
    }, SCALE_LABEL),
    "data-test-subj": "profilingNormalizationMenuFieldNumber",
    id: baselineScaleFactorInputId,
    value: baseline,
    onChange: e => {
      if (mode === NormalizationMode.Scale) {
        setOptions(prevOptions => ({
          ...prevOptions,
          baselineScale: e.target.valueAsNumber
        }));
      }
    },
    disabled: mode === NormalizationMode.Time,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("h6", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.profiling.normalizationMenu.comparison', {
    defaultMessage: 'Comparison'
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    prepend: /*#__PURE__*/_react2.default.createElement(_eui.EuiFormLabel, {
      htmlFor: comparisonScaleFactorInputId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 18
      }
    }, SCALE_LABEL),
    "data-test-subj": "profilingNormalizationMenuFieldNumber",
    id: comparisonScaleFactorInputId,
    value: comparison,
    onChange: e => {
      if (mode === NormalizationMode.Scale) {
        setOptions(prevOptions => ({
          ...prevOptions,
          comparisonScale: e.target.valueAsNumber
        }));
      }
    },
    disabled: mode === NormalizationMode.Time,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "profilingNormalizationMenuApplyChangesButton",
    onClick: () => {
      props.onChange(mode, options);
      setIsPopoverOpen(false);
    },
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.profiling.normalizationMenu.applyChanges', {
    defaultMessage: 'Apply changes'
  })));
}