"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CPULabelWithHint = CPULabelWithHint;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/cpu_label_with_hint/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CPULabelHintMap = {
  self: {
    label: _i18n.i18n.translate('xpack.profiling.cpu.self.label', {
      defaultMessage: 'Self CPU'
    }),
    hint: _i18n.i18n.translate('xpack.profiling.cpu.self.hint', {
      defaultMessage: 'Indicates how much CPU time was spent by the code in the function body, excluding the work done by functions that were called by it'
    })
  },
  total: {
    label: _i18n.i18n.translate('xpack.profiling.cpu.total.label', {
      defaultMessage: 'Total CPU'
    }),
    hint: _i18n.i18n.translate('xpack.profiling.cpu.total.hint', {
      defaultMessage: 'Indicates how much CPU time was spent by the function and any functions called by it'
    })
  }
};
function CPULabelWithHint({
  iconSize,
  labelSize,
  labelStyle,
  type
}) {
  const {
    label,
    hint
  } = CPULabelHintMap[type];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    style: {
      flexGrow: 0
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: labelSize,
    style: labelStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: hint,
    type: "question",
    size: iconSize,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  })));
}