"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomTimeRangeBadge = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/ui-actions-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/data-plugin/common");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _constants = require("./constants");
var _kibana_services = require("../../kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/presentation_panel/public/panel_actions/customize_panel_action/custom_time_range_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class CustomTimeRangeBadge {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _constants.CUSTOM_TIME_RANGE_BADGE);
    (0, _defineProperty2.default)(this, "id", _constants.CUSTOM_TIME_RANGE_BADGE);
    (0, _defineProperty2.default)(this, "order", 7);
    (0, _defineProperty2.default)(this, "MenuItem", ({
      context
    }) => {
      var _core$uiSettings$get;
      const {
        embeddable
      } = context;
      if (!(0, _presentationPublishing.apiPublishesTimeRange)(embeddable)) throw new _public.IncompatibleActionError();
      const timeRange = embeddable.timeRange$.getValue();
      if (!timeRange) {
        throw new _public.IncompatibleActionError();
      }
      return /*#__PURE__*/_react.default.createElement(_eui.PrettyDuration, {
        timeTo: timeRange.to,
        timeFrom: timeRange.from,
        dateFormat: (_core$uiSettings$get = _kibana_services.core.uiSettings.get(_common.UI_SETTINGS.DATE_FORMAT)) !== null && _core$uiSettings$get !== void 0 ? _core$uiSettings$get : 'Browser',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 7
        }
      });
    });
  }
  getDisplayName({
    embeddable
  }) {
    if (!(0, _presentationPublishing.apiPublishesTimeRange)(embeddable)) throw new _public.IncompatibleActionError();
    /**
     * WARNING!! We would not normally return an empty string here - but in order for i18n to be
     * handled properly by the `PrettyDuration` component, we need it to handle the aria label.
     */
    return '';
  }
  couldBecomeCompatible({
    embeddable
  }) {
    return (0, _presentationPublishing.apiPublishesTimeRange)(embeddable);
  }
  getCompatibilityChangesSubject({
    embeddable
  }) {
    return (0, _presentationPublishing.apiPublishesTimeRange)(embeddable) ? embeddable.timeRange$.pipe((0, _rxjs.map)(() => undefined)) : undefined;
  }
  async execute(context) {
    const action = await _kibana_services.uiActions.getAction(_constants.ACTION_CUSTOMIZE_PANEL);
    action.execute(context);
  }
  getIconType() {
    return 'calendar';
  }
  async isCompatible({
    embeddable
  }) {
    if ((0, _presentationPublishing.apiPublishesTimeRange)(embeddable)) {
      const timeRange = embeddable.timeRange$.value;
      return Boolean(timeRange);
    }
    return false;
  }
}
exports.CustomTimeRangeBadge = CustomTimeRangeBadge;