"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CodeEditorField = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _i18n = require("@kbn/i18n");
var _osquery_schema_link = require("../../components/osquery_schema_link");
var _editor = require("../../editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/saved_queries/form/code_editor_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const euiCodeBlockCss = {
  minHeight: '100px'
};
const CodeEditorFieldComponent = ({
  euiFieldProps,
  labelAppend,
  helpText
}) => {
  const {
    field: {
      onChange,
      value
    },
    fieldState: {
      error
    }
  } = (0, _reactHookForm.useController)({
    name: 'query',
    rules: {
      required: {
        message: _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.emptyQueryError', {
          defaultMessage: 'Query is a required field'
        }),
        value: true
      }
    },
    defaultValue: ''
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.osquery.savedQuery.queryEditorLabel', {
      defaultMessage: 'Query'
    }),
    labelAppend: !(0, _fp.isEmpty)(labelAppend) ? labelAppend : /*#__PURE__*/_react.default.createElement(_osquery_schema_link.OsquerySchemaLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 58
      }
    }),
    helpText: helpText,
    isInvalid: !!(error !== null && error !== void 0 && error.message),
    error: error === null || error === void 0 ? void 0 : error.message,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, euiFieldProps !== null && euiFieldProps !== void 0 && euiFieldProps.isDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    css: euiCodeBlockCss,
    language: "sql",
    fontSize: "m",
    paddingSize: "m",
    transparentBackground: !value.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, value) : /*#__PURE__*/_react.default.createElement(_editor.OsqueryEditor, {
    defaultValue: value,
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }));
};
const CodeEditorField = exports.CodeEditorField = /*#__PURE__*/_react.default.memo(CodeEditorFieldComponent);