"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewLiveQueryPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _queryString = _interopRequireDefault(require("query-string"));
var _lodash = require("lodash");
var _layouts = require("../../../components/layouts");
var _kibana = require("../../../common/lib/kibana");
var _live_queries = require("../../../live_queries");
var _use_breadcrumbs = require("../../../common/hooks/use_breadcrumbs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/routes/live_queries/new/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NewLiveQueryPageComponent = () => {
  var _location$state3;
  (0, _use_breadcrumbs.useBreadcrumbs)('live_query_new');
  const {
    replace
  } = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const liveQueryListProps = (0, _kibana.useRouterNavigate)('live_queries');
  const [initialFormData, setInitialFormData] = (0, _react.useState)({});
  const agentPolicyIds = (0, _react.useMemo)(() => {
    const queryParams = _queryString.default.parse(location.search);
    return queryParams !== null && queryParams !== void 0 && queryParams.agentPolicyId ? (0, _lodash.isArray)(queryParams === null || queryParams === void 0 ? void 0 : queryParams.agentPolicyId) ? queryParams === null || queryParams === void 0 ? void 0 : queryParams.agentPolicyId : [queryParams === null || queryParams === void 0 ? void 0 : queryParams.agentPolicyId] : undefined;
  }, [location.search]);
  (0, _react.useEffect)(() => {
    var _location$state;
    if ((_location$state = location.state) !== null && _location$state !== void 0 && _location$state.form) {
      var _location$state2;
      setInitialFormData((_location$state2 = location.state) === null || _location$state2 === void 0 ? void 0 : _location$state2.form);
      replace({
        state: null
      });
    }
  }, [(_location$state3 = location.state) === null || _location$state3 === void 0 ? void 0 : _location$state3.form, replace]);
  const LeftColumn = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    iconType: "arrowLeft"
  }, liveQueryListProps, {
    flush: "left",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.newLiveQuery.viewLiveQueriesHistoryTitle",
    defaultMessage: "View live queries history",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.newLiveQuery.pageTitle",
    defaultMessage: "New live query",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 15
    }
  }))))), [liveQueryListProps]);
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: LeftColumn,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_live_queries.LiveQuery, (0, _extends2.default)({}, initialFormData, {
    agentPolicyIds: agentPolicyIds,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  })));
};
const NewLiveQueryPage = exports.NewLiveQueryPage = /*#__PURE__*/_react.default.memo(NewLiveQueryPageComponent);