"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerOnechatHandlerContext = void 0;
var _spaces = require("./utils/spaces");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerOnechatHandlerContext = ({
  coreSetup
}) => {
  coreSetup.http.registerRouteHandlerContext('onechat', async (context, request) => {
    const [, {
      spaces
    }] = await coreSetup.getStartServices();
    return {
      spaces: {
        getSpaceId: () => (0, _spaces.getCurrentSpaceId)({
          request,
          spaces
        })
      }
    };
  });
};
exports.registerOnechatHandlerContext = registerOnechatHandlerContext;