"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupConversationsByTime = void 0;
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var SectionGroup = /*#__PURE__*/function (SectionGroup) {
  SectionGroup[SectionGroup["Today"] = 0] = "Today";
  SectionGroup[SectionGroup["Yesterday"] = 1] = "Yesterday";
  SectionGroup[SectionGroup["LastWeek"] = 2] = "LastWeek";
  SectionGroup[SectionGroup["Last2Weeks"] = 3] = "Last2Weeks";
  SectionGroup[SectionGroup["LastMonth"] = 4] = "LastMonth";
  SectionGroup[SectionGroup["Last3Months"] = 5] = "Last3Months";
  SectionGroup[SectionGroup["Older"] = 6] = "Older";
  return SectionGroup;
}(SectionGroup || {});
const toLabel = section => {
  switch (section) {
    case SectionGroup.Today:
      return _i18n.i18n.translate('xpack.onechat.conversationSidebar.group.today', {
        defaultMessage: 'Today'
      });
    case SectionGroup.Yesterday:
      return _i18n.i18n.translate('xpack.onechat.conversationSidebar.group.yesterday', {
        defaultMessage: 'Yesterday'
      });
    case SectionGroup.LastWeek:
      return _i18n.i18n.translate('xpack.onechat.conversationSidebar.group.lastWeek', {
        defaultMessage: 'Last Week'
      });
    case SectionGroup.Last2Weeks:
      return _i18n.i18n.translate('xpack.onechat.conversationSidebar.group.last2Weeks', {
        defaultMessage: 'Last 2 Weeks'
      });
    case SectionGroup.LastMonth:
      return _i18n.i18n.translate('xpack.onechat.conversationSidebar.group.lastMonth', {
        defaultMessage: 'Last Month'
      });
    case SectionGroup.Last3Months:
      return _i18n.i18n.translate('xpack.onechat.conversationSidebar.group.last3Months', {
        defaultMessage: 'Last 3 Months'
      });
    case SectionGroup.Older:
      return _i18n.i18n.translate('xpack.onechat.conversationSidebar.group.older', {
        defaultMessage: 'Older'
      });
  }
};
const getTimeSection = updatedAt => {
  const updatedMoment = (0, _moment.default)(updatedAt, _moment.default.ISO_8601);
  // `diff` truncates the result to an integer
  const diffDays = (0, _moment.default)().diff(updatedMoment, 'days');
  if (diffDays === 0) {
    return SectionGroup.Today;
  } else if (diffDays === 1) {
    return SectionGroup.Yesterday;
  } else if (diffDays <= 7) {
    return SectionGroup.LastWeek;
  } else if (diffDays <= 14) {
    return SectionGroup.Last2Weeks;
  } else if (diffDays <= 30) {
    return SectionGroup.LastMonth;
  } else if (diffDays <= 90) {
    return SectionGroup.Last3Months;
  } else {
    return SectionGroup.Older;
  }
};
const orderedSections = [SectionGroup.Today, SectionGroup.Yesterday, SectionGroup.LastWeek, SectionGroup.Last2Weeks, SectionGroup.LastMonth, SectionGroup.Last3Months, SectionGroup.Older];
const groupConversationsByTime = conversations => {
  const groups = {
    [SectionGroup.Today]: [],
    [SectionGroup.Yesterday]: [],
    [SectionGroup.LastWeek]: [],
    [SectionGroup.Last2Weeks]: [],
    [SectionGroup.LastMonth]: [],
    [SectionGroup.Last3Months]: [],
    [SectionGroup.Older]: []
  };
  conversations.forEach(conversation => {
    const section = getTimeSection(conversation.updated_at);
    groups[section].push(conversation);
  });

  // Sort conversations within each group by updated_at (most recent first)
  Object.values(groups).forEach(section => {
    section.sort((a, b) => new Date(b.updated_at).getTime() - new Date(a.updated_at).getTime());
  });
  return orderedSections.filter(section => groups[section].length > 0).map(section => ({
    label: toLabel(section),
    conversations: groups[section]
  }));
};
exports.groupConversationsByTime = groupConversationsByTime;