"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigation = void 0;
var _react = require("react");
var _features = require("../../../common/features");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNavigation = () => {
  const {
    services: {
      application
    }
  } = (0, _use_kibana.useKibana)();
  const navigateToOnechatUrl = (0, _react.useCallback)((path, params, state) => {
    const queryParams = new URLSearchParams(params);
    application.navigateToApp(_features.ONECHAT_APP_ID, {
      path: queryParams.size ? `${path}?${queryParams}` : path,
      state
    });
  }, [application]);
  const createOnechatUrl = (0, _react.useCallback)((path, params) => {
    const queryParams = new URLSearchParams(params);
    return application.getUrlForApp(_features.ONECHAT_APP_ID, {
      path: queryParams.size ? `${path}?${queryParams}` : path
    });
  }, [application]);
  return {
    createOnechatUrl,
    navigateToOnechatUrl
  };
};
exports.useNavigation = useNavigation;