"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.McpConnectionButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../../../../../common/doc_links");
var _use_kibana_url = require("../../../hooks/use_kibana_url");
var _mcp = require("../../../../../common/mcp");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/mcp_server/mcp_connection_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const McpConnectionButton = () => {
  const [isContextOpen, setIsContextOpen] = (0, _react.useState)(false);
  const {
    kibanaUrl
  } = (0, _use_kibana_url.useKibanaUrl)();
  const mcpServerUrl = `${kibanaUrl}${_mcp.MCP_SERVER_PATH}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      key: "mcp-server-connection-button",
      iconType: "arrowDown",
      onClick: () => setIsContextOpen(true),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.onechat.tools.mcpServerConnectionButton', {
      defaultMessage: 'MCP Server'
    }))),
    isOpen: isContextOpen,
    closePopover: () => setIsContextOpen(false),
    anchorPosition: "downLeft",
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      key: "copy",
      textToCopy: mcpServerUrl,
      tooltipProps: {
        anchorClassName: 'eui-fullWidth'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "copy",
      icon: "copy",
      onClick: copy,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.onechat.tools.copyMcpServerUrlButton', {
      defaultMessage: 'Copy MCP Server URL'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "documentation",
      href: _doc_links.docLinks.mcpServer,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.onechat.tools.aboutMcpServerDocumentationButton', {
      defaultMessage: 'Documentation'
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }));
};
exports.McpConnectionButton = McpConnectionButton;