"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationItem = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_conversation_id = require("../../../hooks/use_conversation_id");
var _use_navigation = require("../../../hooks/use_navigation");
var _app_paths = require("../../../utils/app_paths");
var _use_conversation_actions = require("../../../hooks/use_conversation_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_sidebar/conversation_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConversationItem = ({
  conversation
}) => {
  const {
    createOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const currentConversationId = (0, _use_conversation_id.useConversationId)();
  const {
    deleteConversation
  } = (0, _use_conversation_actions.useConversationActions)();
  const isActive = currentConversationId === conversation.id;
  const [showDeleteModal, setShowDeleteModal] = (0, _react.useState)(false);
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'deleteConversationModal'
  });
  const handleDelete = (0, _react.useCallback)(async () => {
    setShowDeleteModal(false);
    await deleteConversation(conversation.id);
  }, [conversation.id, deleteConversation]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    color: "text",
    size: "s",
    href: createOnechatUrl(_app_paths.appPaths.chat.conversation({
      conversationId: conversation.id
    })),
    "data-test-subj": `conversationItem-${conversation.id}`,
    label: conversation.title,
    isActive: isActive,
    extraAction: {
      iconType: 'trash',
      color: 'danger',
      'aria-label': _i18n.i18n.translate('xpack.onechat.conversationItem.deleteConversationIconLabel', {
        defaultMessage: 'Delete conversation'
      }),
      onClick: () => setShowDeleteModal(true),
      'data-test-subj': 'delete-conversation-button'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }), showDeleteModal && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.conversationItem.deleteConversationModal.title",
      defaultMessage: "Delete conversation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 13
      }
    }),
    titleProps: {
      id: confirmModalTitleId
    },
    onCancel: () => setShowDeleteModal(false),
    onConfirm: handleDelete,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.conversationItem.deleteConversationModal.cancelButton",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 13
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.conversationItem.deleteConversationModal.confirmButton",
      defaultMessage: "Delete",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 13
      }
    }),
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.conversationItem.deleteConversationModal.description",
    defaultMessage: "Are you sure you want to delete the conversation {title}? This action cannot be undone.",
    values: {
      title: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 24
        }
      }, conversation.title)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }))));
};
exports.ConversationItem = ConversationItem;