"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getObservabilityOnboardingServerRouteRepository = void 0;
var _route = require("./flow/route");
var _route2 = require("./kubernetes/route");
var _route3 = require("./firehose/route");
var _route4 = require("./otel_host/route");
var _route5 = require("./otel_apm/route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTypedObservabilityOnboardingServerRouteRepository() {
  const repository = {
    ..._route.flowRouteRepository,
    ..._route2.kubernetesOnboardingRouteRepository,
    ..._route3.firehoseOnboardingRouteRepository,
    ..._route4.otelHostOnboardingRouteRepository,
    ..._route5.otelApmOnboardingRouteRepository
  };
  return repository;
}
const getObservabilityOnboardingServerRouteRepository = () => {
  return getTypedObservabilityOnboardingServerRouteRepository();
};
exports.getObservabilityOnboardingServerRouteRepository = getObservabilityOnboardingServerRouteRepository;