"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogStashOverviewPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _public = require("@kbn/kibana-react-plugin/public");
var _global_state_context = require("../../contexts/global_state_context");
var _use_charts = require("../../hooks/use_charts");
var _overview = require("../../../components/logstash/overview");
var _logstash_template = require("./logstash_template");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/logstash/overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogStashOverviewPage = ({
  clusters
}) => {
  var _services$data2;
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const {
    zoomInfo,
    onBrush
  } = (0, _use_charts.useCharts)();
  const {
    services
  } = (0, _public.useKibana)();
  const clusterUuid = globalState.cluster_uuid;
  const ccs = globalState.ccs;
  const cluster = (0, _lodash.find)(clusters, {
    cluster_uuid: clusterUuid
  });
  const {
    generate: generateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  const [data, setData] = (0, _react.useState)(null);
  // const [showShardActivityHistory, setShowShardActivityHistory] = useState(false);

  const title = _i18n.i18n.translate('xpack.monitoring.logstash.overview.title', {
    defaultMessage: 'Logstash'
  });
  const pageTitle = _i18n.i18n.translate('xpack.monitoring.logstash.overview.pageTitle', {
    defaultMessage: 'Logstash overview'
  });
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data, _services$http;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    const url = `../api/monitoring/v1/clusters/${clusterUuid}/logstash`;
    const response = await ((_services$http = services.http) === null || _services$http === void 0 ? void 0 : _services$http.fetch(url, {
      method: 'POST',
      body: JSON.stringify({
        ccs,
        timeRange: {
          min: bounds.min.toISOString(),
          max: bounds.max.toISOString()
        }
      })
    }));
    setData(response);
  }, [ccs, clusterUuid, (_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter, services.http]);
  (0, _react.useEffect)(() => {
    if (cluster) {
      generateBreadcrumbs(cluster.cluster_name, {
        inLogstash: true
      });
    }
  }, [cluster, data, generateBreadcrumbs]);
  const renderOverview = overviewData => {
    if (overviewData === null) {
      return null;
    }
    const {
      clusterStatus,
      metrics,
      logs
    } = overviewData || {};
    return /*#__PURE__*/_react.default.createElement(_overview.Overview, {
      stats: clusterStatus,
      metrics: metrics,
      logs: logs,
      onBrush: onBrush,
      zoomInfo: zoomInfo,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 7
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_logstash_template.LogstashTemplate, {
    title: title,
    pageTitle: pageTitle,
    getPageData: getPageData,
    cluster: cluster,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "logstashOverviewPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, renderOverview(data)));
};
exports.LogStashOverviewPage = LogStashOverviewPage;