"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SparseDataSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _job_creator_context = require("../../../job_creator_context");
var _description = require("./description");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/sparse_data/sparse_data_switch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SparseDataSwitch = () => {
  const {
    jobCreator,
    jobCreatorUpdated,
    jobCreatorUpdate
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [sparseData, setSparseData] = (0, _react.useState)(jobCreator.sparseData);
  const [enabled, setEnabled] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    jobCreator.sparseData = sparseData;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [sparseData]);
  (0, _react.useEffect)(() => {
    const aggs = [_mlAnomalyUtils.ES_AGGREGATION.COUNT, _mlAnomalyUtils.ES_AGGREGATION.SUM];
    const isCountOrSum = jobCreator.aggregations.some(agg => agg.dslName !== null && aggs.includes(agg.dslName));
    setEnabled(isCountOrSum);
    if (isCountOrSum === false && sparseData === true) {
      setSparseData(false);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  function toggleSparseData() {
    setSparseData(!sparseData);
  }
  return /*#__PURE__*/_react.default.createElement(_description.Description, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "switch",
    disabled: enabled === false,
    checked: sparseData,
    onChange: toggleSparseData,
    "data-test-subj": "mlJobWizardSwitchSparseData",
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.sparseData.title', {
      defaultMessage: 'Sparse data'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }));
};
exports.SparseDataSwitch = SparseDataSwitch;