"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategorizationView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _metric_selection = require("./metric_selection");
var _metric_selection_summary = require("./metric_selection_summary");
var _settings = require("./settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/categorization_view/categorization_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CategorizationView = ({
  isActive,
  setCanProceed
}) => {
  const [categoryFieldValid, setCategoryFieldValid] = (0, _react.useState)(false);
  const [settingsValid, setSettingsValid] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (typeof setCanProceed === 'function') {
      setCanProceed(categoryFieldValid && settingsValid);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [categoryFieldValid, settingsValid]);
  return isActive === false ? /*#__PURE__*/_react.default.createElement(_metric_selection_summary.CategorizationDetectorsSummary, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_metric_selection.CategorizationDetectors, {
    setIsValid: setCategoryFieldValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }), categoryFieldValid && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_settings.CategorizationSettings, {
    setIsValid: setSettingsValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  })));
};
exports.CategorizationView = CategorizationView;