"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobFilterBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _job_group = require("../job_group");
var _kibana = require("../../../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/job_filter_bar/job_filter_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JobFilterBar = ({
  queryText,
  setFilters
}) => {
  const [error, setError] = (0, _react.useState)(null);
  const {
    services: {
      mlServices: {
        mlApi
      }
    }
  } = (0, _kibana.useMlKibana)();
  const loadGroups = (0, _react.useCallback)(async () => {
    try {
      const response = await mlApi.jobs.groups();
      return response.map(g => ({
        value: g.id,
        view: /*#__PURE__*/_react.default.createElement("div", {
          className: "group-item",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 37,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_job_group.JobGroup, {
          name: g.id,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 38,
            columnNumber: 13
          }
        }), "\xA0", /*#__PURE__*/_react.default.createElement("span", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 40,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.jobsList.jobFilterBar.jobGroupTitle",
          defaultMessage: "({jobsCount, plural, one {# job} other {# jobs}})",
          values: {
            jobsCount: g.jobIds.length
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 41,
            columnNumber: 15
          }
        })))
      }));
    } catch (e) {
      return [];
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const queryInstance = (0, _react.useMemo)(() => {
    return _eui.EuiSearchBar.Query.parse(queryText !== null && queryText !== void 0 ? queryText : '');
  }, [queryText]);
  const onChange = ({
    query,
    error: queryError
  }) => {
    if (queryError) {
      setError(queryError);
    } else {
      setFilters(query);
      setError(null);
    }
  };
  (0, _react.useEffect)(() => {
    if (queryText !== undefined) {
      setFilters(queryInstance);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [queryText]);
  const filters = (0, _react.useMemo)(() => [{
    type: 'field_value_toggle_group',
    field: 'job_state',
    items: [{
      value: 'opened',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobFilterBar.openedLabel', {
        defaultMessage: 'Opened'
      })
    }, {
      value: 'closed',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobFilterBar.closedLabel', {
        defaultMessage: 'Closed'
      })
    }, {
      value: 'failed',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobFilterBar.failedLabel', {
        defaultMessage: 'Failed'
      })
    }]
  }, {
    type: 'field_value_toggle_group',
    field: 'datafeed_state',
    items: [{
      value: 'started',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobFilterBar.startedLabel', {
        defaultMessage: 'Started'
      })
    }, {
      value: 'stopped',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobFilterBar.stoppedLabel', {
        defaultMessage: 'Stopped'
      })
    }]
  }, {
    type: 'field_value_selection',
    field: 'groups',
    name: _i18n.i18n.translate('xpack.ml.jobsList.jobFilterBar.groupLabel', {
      defaultMessage: 'Group'
    }),
    multiSelect: 'or',
    cache: 10000,
    options: () => loadGroups()
  }],
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const errorText = (0, _react.useMemo)(() => {
    if (error === null) return '';
    return _i18n.i18n.translate('xpack.ml.jobsList.jobFilterBar.invalidSearchErrorMessage', {
      defaultMessage: 'Invalid search: {errorMessage}',
      values: {
        errorMessage: error.message
      }
    });
  }, [error]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "mlJobListSearchBar",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    box: {
      incremental: true
    },
    query: queryInstance,
    filters: filters,
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: error !== null,
    error: errorText,
    style: {
      maxHeight: 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }))));
};
exports.JobFilterBar = JobFilterBar;