"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorerQueryBar = exports.DEFAULT_QUERY_LANG = void 0;
exports.getKqlQueryValues = getKqlQueryValues;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _app = require("../../../../../common/constants/app");
var _anomaly_explorer_context = require("../../anomaly_explorer_context");
var _kibana = require("../../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/components/explorer_query_bar/explorer_query_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_QUERY_LANG = exports.DEFAULT_QUERY_LANG = _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY;
function getKqlQueryValues({
  inputString,
  queryLanguage,
  indexPattern
}) {
  var _influencersFilterQue;
  let influencersFilterQuery = {};
  const filteredFields = [];
  const ast = (0, _esQuery.fromKueryExpression)(inputString);
  const isAndOperator = ast && ast.function === 'and';
  // if ast.type == 'function' then layout of ast.arguments:
  // [{ arguments: [ { type: 'literal', value: 'AAL' } ] },{ arguments: [ { type: 'literal', value: 'AAL' } ] }]
  if (ast && Array.isArray(ast.arguments)) {
    ast.arguments.forEach(arg => {
      if (arg.arguments !== undefined) {
        arg.arguments.forEach(nestedArg => {
          if (typeof nestedArg.value === 'string') {
            filteredFields.push(nestedArg.value);
          }
        });
      } else if (typeof arg.value === 'string') {
        filteredFields.push(arg.value);
      }
    });
  }
  if (queryLanguage === _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY) {
    influencersFilterQuery = (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(inputString), indexPattern);
  } else if (queryLanguage === _mlQueryUtils.SEARCH_QUERY_LANGUAGE.LUCENE) {
    influencersFilterQuery = (0, _esQuery.luceneStringToDsl)(inputString);
  }
  const clearSettings = Boolean(((_influencersFilterQue = influencersFilterQuery) === null || _influencersFilterQue === void 0 ? void 0 : _influencersFilterQue.match_all) && Object.keys(influencersFilterQuery.match_all).length === 0);
  return {
    clearSettings,
    settings: {
      filterQuery: influencersFilterQuery,
      queryString: inputString,
      tableQueryString: inputString,
      isAndOperator,
      filteredFields
    }
  };
}
function getInitSearchInputState({
  queryString,
  searchInput
}) {
  var _searchInput$language;
  return {
    language: (_searchInput$language = searchInput === null || searchInput === void 0 ? void 0 : searchInput.language) !== null && _searchInput$language !== void 0 ? _searchInput$language : DEFAULT_QUERY_LANG,
    query: queryString !== null && queryString !== void 0 ? queryString : ''
  };
}
const ExplorerQueryBar = ({
  filterActive,
  filterPlaceHolder,
  indexPattern,
  queryString,
  updateLanguage,
  dataViews = []
}) => {
  const {
    anomalyExplorerCommonStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const {
    services
  } = (0, _kibana.useMlKibana)();
  const {
    unifiedSearch: {
      ui: {
        QueryStringInput
      }
    }
  } = services;

  // The internal state of the input query bar updated on every key stroke.
  const [searchInput, setSearchInput] = (0, _react.useState)(getInitSearchInputState({
    queryString
  }));
  const [queryErrorMessage, setQueryErrorMessage] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(function updateSearchInputFromFilter() {
    setSearchInput(getInitSearchInputState({
      queryString,
      searchInput
    }));
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [queryString, searchInput.language]);
  const searchChangeHandler = query => {
    if (searchInput.language !== query.language) {
      updateLanguage(query.language);
    }
    setSearchInput(query);
  };
  const applyInfluencersFilterQuery = query => {
    try {
      const {
        clearSettings,
        settings
      } = getKqlQueryValues({
        inputString: query.query,
        queryLanguage: query.language,
        indexPattern
      });
      if (clearSettings === true) {
        anomalyExplorerCommonStateService.clearFilterSettings();
      } else {
        anomalyExplorerCommonStateService.setFilterSettings(settings);
      }
    } catch (e) {
      console.log('Invalid query syntax in search bar', e); // eslint-disable-line no-console
      setQueryErrorMessage({
        query: query.query,
        message: e.message
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, {
    css: {
      maxWidth: '100%'
    },
    closePopover: setQueryErrorMessage.bind(null, undefined),
    input: /*#__PURE__*/_react.default.createElement(QueryStringInput, {
      bubbleSubmitEvent: false,
      query: searchInput,
      indexPatterns: dataViews !== null && dataViews !== void 0 ? dataViews : [],
      onChange: searchChangeHandler,
      onSubmit: applyInfluencersFilterQuery,
      placeholder: filterPlaceHolder,
      disableAutoFocus: true,
      dataTestSubj: "explorerQueryInput",
      languageSwitcherPopoverAnchorPosition: "rightDown",
      appName: _app.PLUGIN_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 9
      }
    }),
    isOpen: (queryErrorMessage === null || queryErrorMessage === void 0 ? void 0 : queryErrorMessage.query) === searchInput.query && (queryErrorMessage === null || queryErrorMessage === void 0 ? void 0 : queryErrorMessage.message) !== '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.ml.explorer.invalidKuerySyntaxErrorMessageQueryBar', {
    defaultMessage: 'Invalid query'
  }), ': ', queryErrorMessage === null || queryErrorMessage === void 0 ? void 0 : queryErrorMessage.message.split('\n')[0]));
};
exports.ExplorerQueryBar = ExplorerQueryBar;