"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedStepDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _state = require("../../../analytics_management/hooks/use_create_analytics_form/state");
var _page = require("../../page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/advanced_step/advanced_step_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getStringValue(value) {
  return typeof value === 'number' ? `${value}` : _state.UNSET_CONFIG_ITEM;
}
const AdvancedStepDetails = ({
  setCurrentStep,
  state
}) => {
  const {
    form,
    isJobCreated
  } = state;
  const {
    computeFeatureInfluence,
    dependentVariable,
    eta,
    featureBagFraction,
    featureInfluenceThreshold,
    gamma,
    jobType,
    lambda,
    method,
    maxNumThreads,
    maxTrees,
    modelMemoryLimit,
    nNeighbors,
    numTopClasses,
    numTopFeatureImportanceValues,
    outlierFraction,
    predictionFieldName,
    randomizeSeed,
    standardizationEnabled
  } = form;
  const isRegOrClassJob = jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION || jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION;
  const advancedFirstCol = [];
  const advancedSecondCol = [];
  const advancedThirdCol = [];
  const hyperFirstCol = [];
  const hyperSecondCol = [];
  const hyperThirdCol = [];
  if (jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION) {
    advancedFirstCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.computeFeatureInfluence', {
        defaultMessage: 'Compute feature influence'
      }),
      description: computeFeatureInfluence.toString()
    });
    advancedSecondCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.featureInfluenceThreshold', {
        defaultMessage: 'Feature influence threshold'
      }),
      description: getStringValue(featureInfluenceThreshold)
    });
    advancedThirdCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.modelMemoryLimit', {
        defaultMessage: 'Model memory limit'
      }),
      description: `${modelMemoryLimit}`
    });
    hyperFirstCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.nNeighbors', {
        defaultMessage: 'N neighbors'
      }),
      description: getStringValue(nNeighbors)
    }, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.outlierFraction', {
        defaultMessage: 'Outlier fraction'
      }),
      description: getStringValue(outlierFraction)
    });
    hyperSecondCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.method', {
        defaultMessage: 'Method'
      }),
      description: method !== undefined ? method : _state.UNSET_CONFIG_ITEM
    });
    hyperThirdCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.standardizationEnabled', {
        defaultMessage: 'Standardization enabled'
      }),
      description: `${standardizationEnabled}`
    });
  }
  if (isRegOrClassJob) {
    advancedFirstCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.numTopFeatureImportanceValues', {
        defaultMessage: 'Top feature importance values'
      }),
      description: `${numTopFeatureImportanceValues}`
    });
    hyperFirstCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.lambdaFields', {
        defaultMessage: 'Lambda'
      }),
      description: getStringValue(lambda)
    }, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.eta', {
        defaultMessage: 'Eta'
      }),
      description: getStringValue(eta)
    });
    advancedSecondCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.predictionFieldName', {
        defaultMessage: 'Prediction field name'
      }),
      description: predictionFieldName ? predictionFieldName : `${dependentVariable}_prediction`
    }, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.randomizedSeed', {
        defaultMessage: 'Randomized seed'
      }),
      description: getStringValue(randomizeSeed)
    });
    hyperSecondCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.maxTreesFields', {
        defaultMessage: 'Max trees'
      }),
      description: getStringValue(maxTrees)
    }, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.featureBagFraction', {
        defaultMessage: 'Feature bag fraction'
      }),
      description: getStringValue(featureBagFraction)
    });
    advancedThirdCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.modelMemoryLimit', {
        defaultMessage: 'Model memory limit'
      }),
      description: `${modelMemoryLimit}`
    });
    hyperThirdCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.gamma', {
        defaultMessage: 'Gamma'
      }),
      description: getStringValue(gamma)
    });
  }
  if (jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION) {
    advancedThirdCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.numTopClasses', {
        defaultMessage: 'Top classes'
      }),
      description: numTopClasses === -1 ? _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.allClasses', {
        defaultMessage: 'All classes'
      }) : getStringValue(numTopClasses)
    });
  }
  if (maxNumThreads !== undefined) {
    advancedFirstCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.maxNumThreads', {
        defaultMessage: 'Maximum number of threads'
      }),
      description: `${maxNumThreads}`
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.advancedConfigDetailsTitle', {
    defaultMessage: 'Advanced configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      width: '70%'
    },
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: advancedFirstCol,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: advancedSecondCol,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: advancedThirdCol,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.hyperParametersDetailsTitle', {
    defaultMessage: 'Hyperparameters'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      width: '70%'
    },
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: hyperFirstCol,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: hyperSecondCol,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: hyperThirdCol,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 7
    }
  }), !isJobCreated && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "pencil",
    size: "s",
    onClick: () => {
      setCurrentStep(_page.ANALYTICS_STEPS.ADVANCED);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.advancedDetails.editButtonText', {
    defaultMessage: 'Edit'
  })));
};
exports.AdvancedStepDetails = AdvancedStepDetails;