"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInfluencersListStyles = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInfluencersListStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const euiFontSizeXS = (0, _eui.useEuiFontSize)('xs').fontSize;
  const euiFontSizeM = (0, _eui.useEuiFontSize)('m').fontSize;
  return {
    influencersList: (0, _react.css)({
      lineHeight: 1.45
    }),
    fieldLabel: (0, _react.css)({
      fontSize: euiFontSizeXS,
      textAlign: 'left',
      maxHeight: euiFontSizeM,
      maxWidth: 'calc(100% - 102px)'
    }),
    progressBar: (0, _react.css)({
      backgroundColor: euiTheme.colors.backgroundBaseSubdued,
      '&::-webkit-progress-bar': {
        backgroundColor: euiTheme.colors.backgroundBaseSubdued
      }
    }),
    progressColor: severity => severity.id === 'critical' ? (0, _mlAnomalyUtils.getThemeResolvedSeverityColor)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.CRITICAL, euiTheme) : severity.id === 'major' ? (0, _mlAnomalyUtils.getThemeResolvedSeverityColor)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MAJOR, euiTheme) : severity.id === 'minor' ? (0, _mlAnomalyUtils.getThemeResolvedSeverityColor)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MINOR, euiTheme) : severity.id === 'warning' ? (0, _mlAnomalyUtils.getThemeResolvedSeverityColor)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.WARNING, euiTheme) : severity.id === 'low' ? (0, _mlAnomalyUtils.getThemeResolvedSeverityColor)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.LOW, euiTheme) : euiTheme.colors.severity.unknown,
    influencerBadgeBackgroundColor: severity => severity.id === 'critical' ? euiTheme.colors.backgroundLightDanger : severity.id === 'major' ? euiTheme.colors.backgroundLightRisk : severity.id === 'minor' ? euiTheme.colors.backgroundLightWarning : severity.id === 'warning' || severity.id === 'low' ? euiTheme.colors.backgroundLightNeutral : euiTheme.colors.backgroundLightPrimary,
    influencerBadgeTextColor: severity => (0, _react.css)({
      color: severity.id === 'critical' ? euiTheme.colors.textDanger : severity.id === 'major' ? euiTheme.colors.textRisk : severity.id === 'minor' ? euiTheme.colors.textWarning : severity.id === 'warning' || severity.id === 'low' ? euiTheme.colors.textNeutral : euiTheme.colors.textSubdued
    })
  };
};
exports.useInfluencersListStyles = useInfluencersListStyles;