"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectorCell = DetectorCell;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/anomalies_table/detector_cell.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Component for rendering a detector cell in the anomalies table, displaying the
 * description of the detector, and an icon if rules have been configured for the detector.
 */
function DetectorCell({
  detectorDescription,
  numberOfRules
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  let rulesIcon;
  if (numberOfRules !== undefined && numberOfRules > 0) {
    rulesIcon = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.detectorCell.rulesConfiguredTooltip",
        defaultMessage: "rules have been configured for this detector",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 25,
          columnNumber: 11
        }
      }),
      type: "controlsHorizontal",
      css: {
        marginLeft: euiTheme.size.xs
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, detectorDescription, rulesIcon);
}
DetectorCell.propTypes = {
  detectorDescription: _propTypes.default.string.isRequired,
  numberOfRules: _propTypes.default.number
};